/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.packet;

import java.util.Optional;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.packet.AbstractPacketReader;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.packet.PayloadFragment;
import org.eclipse.sensinact.gateway.generic.packet.PayloadFragmentImpl;
import org.eclipse.sensinact.gateway.generic.packet.PayloadResourceFragmentImpl;
import org.eclipse.sensinact.gateway.generic.packet.PayloadServiceFragmentImpl;

public abstract class SimplePacketReader<P extends Packet>
extends AbstractPacketReader<P> {
    protected String profileId;
    protected String serviceProviderId;
    protected String serviceId;
    protected String resourceId;
    protected String attributeId;
    protected String metadataId;
    protected long timestamp;
    protected Object data;
    protected boolean isHelloMessage;
    protected boolean isGoodbyeMessage;
    protected Task.CommandType command;

    protected SimplePacketReader() {
    }

    protected void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    protected void setServiceProviderId(String serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }

    protected void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    protected void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    protected void setAttributeId(String attributeId) {
        this.attributeId = attributeId;
    }

    protected void setMetadataId(String metadataId) {
        this.metadataId = metadataId;
    }

    protected void setData(Object data) {
        this.data = data;
    }

    protected void setCommand(Task.CommandType command) {
        this.command = command;
    }

    public void isHelloMessage(boolean isHelloMessage) {
        this.isHelloMessage = isHelloMessage;
    }

    public void isGoodbyeMessage(boolean isGoodbyeMessage) {
        this.isGoodbyeMessage = isGoodbyeMessage;
    }

    public long setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this.timestamp;
    }

    protected void configureEOF() {
        this.reset();
        super.setSubPacket(PayloadFragment.EOF_FRAGMENT);
    }

    protected void configure() {
        String name;
        PayloadFragmentImpl subPacket = null;
        if (this.serviceProviderId == null) {
            this.configureEOF();
            return;
        }
        subPacket = this.newSubPacket();
        subPacket.setProfileId(this.profileId);
        subPacket.setServiceProviderIdentifier(this.serviceProviderId);
        subPacket.isGoodbyeMessage(this.isGoodbyeMessage);
        subPacket.isHelloMessage(this.isHelloMessage);
        StringBuilder builder = new StringBuilder();
        if (this.command != null) {
            builder.append(this.command.name());
            if (this.serviceId != null) {
                builder.append('#');
            }
        }
        if (this.serviceId != null) {
            builder.append(this.serviceId);
            if (this.resourceId != null) {
                builder.append('#');
            }
        }
        if (this.resourceId != null) {
            builder.append(this.resourceId);
        }
        if ((name = builder.toString()).length() > 0) {
            PayloadServiceFragmentImpl payloadFragment = null;
            Optional<PayloadServiceFragmentImpl> found = subPacket.payloadFragments.stream().filter(PayloadServiceFragmentImpl.class::isInstance).map(PayloadServiceFragmentImpl.class::cast).filter(psf -> psf.getName().equals(name)).findFirst();
            if (found.isPresent()) {
                payloadFragment = found.get();
            } else {
                payloadFragment = this.newPayloadFragment();
                payloadFragment.setCommand(this.command);
                payloadFragment.setServiceId(this.serviceId);
                payloadFragment.setResourceId(this.resourceId);
                subPacket.addPayloadFragment(payloadFragment);
            }
            if (this.attributeId != null || this.data != null) {
                PayloadResourceFragmentImpl payloadAttributeFragment = this.newPayloadAttributeFragment(this.attributeId, this.metadataId, this.data);
                payloadAttributeFragment.setTimestamp(this.timestamp);
                payloadFragment.addPayloadAttributeFragment(payloadAttributeFragment);
            }
        }
        this.reset();
        super.setSubPacket(subPacket);
    }

    @Override
    public void reset() {
        this.resetFields();
        this.subPacket = null;
    }

    private final void resetFields() {
        this.isGoodbyeMessage = false;
        this.isHelloMessage = false;
        this.command = null;
        this.serviceProviderId = null;
        this.serviceId = null;
        this.resourceId = null;
        this.attributeId = null;
        this.metadataId = null;
        this.timestamp = -1L;
        this.data = null;
    }

    protected PayloadFragmentImpl newSubPacket() {
        return new PayloadFragmentImpl();
    }

    protected PayloadServiceFragmentImpl newPayloadFragment() {
        return new PayloadServiceFragmentImpl();
    }

    private PayloadResourceFragmentImpl newPayloadAttributeFragment(String attributeId, String metadataId, Object data) {
        return new PayloadResourceFragmentImpl(attributeId, metadataId, data);
    }
}

