/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.primitive;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueTypeException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class Primitive
implements Nameable {
    protected final Object lock = new Object();
    protected final Class<?> type;
    protected final String name;
    protected Object value;
    protected Mediator mediator;

    public abstract Modifiable getModifiable();

    protected abstract void beforeChange(Object var1) throws InvalidValueException;

    protected abstract void afterChange(Object var1) throws InvalidValueException;

    protected Primitive(Mediator mediator, String name, Class<?> type) throws InvalidValueException {
        this.checkType(type);
        this.mediator = mediator;
        this.name = name;
        this.type = type;
    }

    protected Primitive(Mediator mediator, String name, String type) throws InvalidValueException {
        if (name == null || type == null) {
            throw new InvalidValueException("name and type are required");
        }
        this.mediator = mediator;
        Class clazz = null;
        try {
            clazz = CastUtils.loadClass((ClassLoader)mediator.getClassLoader(), (String)type);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidValueException("Invalid type :" + type);
        }
        this.checkType(clazz);
        this.name = name;
        this.type = clazz;
    }

    protected Primitive(Mediator mediator, String name, Class<?> type, Object value) throws InvalidValueException {
        this(mediator, name, type);
        if (value != null) {
            this.setValue(value);
        }
    }

    protected Primitive(Mediator mediator, JSONObject jsonObject) throws InvalidValueException {
        this(mediator, jsonObject == null ? null : jsonObject.optString("name"), jsonObject == null ? null : jsonObject.optString("type"));
        Object ovalue = jsonObject.opt("value");
        if (ovalue != null) {
            this.setValue(CastUtils.getObjectFromJSON(this.getType(), (Object)ovalue));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        Object value = null;
        Object object = this.lock;
        synchronized (object) {
            value = CastUtils.copy(this.type, (Object)this.value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setValue(Object value) throws InvalidValueException {
        if (Modifiable.FIXED.equals((Object)this.getModifiable())) {
            throw new InvalidValueException("the value cannot be modified");
        }
        Object valueObject = this.cast(value);
        Object copy = CastUtils.copy(this.type, (Object)valueObject);
        Object object = this.lock;
        synchronized (object) {
            boolean hasChanged = valueObject == null && this.value != null || valueObject != null && !valueObject.equals(this.value);
            this.beforeChange(copy);
            this.value = valueObject;
            if (hasChanged) {
                this.afterChange(copy);
            }
        }
        return copy;
    }

    protected void checkType(Class<?> type) throws InvalidValueTypeException {
        if (!(CastUtils.isPrimitive(type) || JSONObject.class.isAssignableFrom(type) || JSONArray.class.isAssignableFrom(type) || type.isEnum() || type.isArray() && CastUtils.isPrimitive(type.getComponentType()))) {
            throw new InvalidValueTypeException("Invalid type : " + type.getCanonicalName());
        }
    }

    protected Object cast(Object value) throws InvalidValueException {
        if (value == null) {
            return value;
        }
        Object valueObject = null;
        try {
            valueObject = CastUtils.cast(this.getType(), (Object)value);
        }
        catch (ClassCastException e) {
            throw new InvalidValueException(e);
        }
        return valueObject;
    }
}

