/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.aries.rsa.spi.ExportPolicy;
import org.apache.aries.rsa.topologymanager.exporter.EndpointListenerNotifier;
import org.apache.aries.rsa.topologymanager.exporter.ServiceExportsRepository;
import org.apache.aries.rsa.util.StringPlus;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyManagerExport
implements ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyManagerExport.class);
    private final Executor execService;
    private final Map<RemoteServiceAdmin, ServiceExportsRepository> endpointRepo;
    private ExportPolicy policy;
    private Map<Integer, String> typeNames;
    private final EndpointListenerNotifier notifier;
    private Set<ServiceReference<?>> toBeExported;

    public TopologyManagerExport(EndpointListenerNotifier notifier, Executor executor, ExportPolicy policy) {
        this.notifier = notifier;
        this.execService = executor;
        this.policy = policy;
        this.endpointRepo = new HashMap<RemoteServiceAdmin, ServiceExportsRepository>();
        this.toBeExported = new HashSet();
        this.createTypeNames();
    }

    private void createTypeNames() {
        this.typeNames = new HashMap<Integer, String>();
        this.typeNames.put(2, "modified");
        this.typeNames.put(8, "modified endmatch");
        this.typeNames.put(1, "registered");
        this.typeNames.put(4, "unregistering");
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference sref = event.getServiceReference();
        if (!this.shouldExport(sref)) {
            LOG.debug("Skipping service {}", (Object)sref);
            return;
        }
        LOG.info("Received ServiceEvent type: {}, sref: {}", (Object)this.getTypeName(event), (Object)sref);
        switch (event.getType()) {
            case 1: {
                this.doExport(sref);
                break;
            }
            case 2: {
                this.modified(sref);
                break;
            }
            case 8: {
                this.remove(sref);
                break;
            }
            case 4: {
                this.remove(sref);
            }
        }
    }

    private void modified(ServiceReference<?> sref) {
        for (RemoteServiceAdmin rsa : this.endpointRepo.keySet()) {
            ServiceExportsRepository repo = this.endpointRepo.get(rsa);
            repo.modifyService(sref);
        }
    }

    private void remove(ServiceReference<?> sref) {
        this.toBeExported.remove(sref);
        for (RemoteServiceAdmin rsa : this.endpointRepo.keySet()) {
            ServiceExportsRepository repo = this.endpointRepo.get(rsa);
            repo.removeService(sref);
        }
    }

    public String getTypeName(ServiceEvent event) {
        return this.typeNames.get(event.getType());
    }

    public void add(RemoteServiceAdmin rsa) {
        this.endpointRepo.put(rsa, new ServiceExportsRepository(rsa, this.notifier));
        for (ServiceReference<?> serviceRef : this.toBeExported) {
            this.exportInBackground(serviceRef);
        }
    }

    public void remove(RemoteServiceAdmin rsa) {
        ServiceExportsRepository repo = this.endpointRepo.remove(rsa);
        if (repo != null) {
            repo.close();
        }
    }

    private void exportInBackground(final ServiceReference<?> sref) {
        this.execService.execute(new Runnable(){

            @Override
            public void run() {
                TopologyManagerExport.this.doExport(sref);
            }
        });
    }

    private void doExport(ServiceReference<?> sref) {
        LOG.debug("Exporting service {}", sref);
        this.toBeExported.add(sref);
        if (this.endpointRepo.size() == 0) {
            LOG.error("Unable to export service from bundle {}, interfaces: {} as no RemoteServiceAdmin is available. Marked for later export.", this.getSymbolicName(sref.getBundle()), sref.getProperty("objectClass"));
            return;
        }
        for (RemoteServiceAdmin remoteServiceAdmin : this.endpointRepo.keySet()) {
            ServiceExportsRepository repo = this.endpointRepo.get(remoteServiceAdmin);
            Collection<ExportRegistration> regs = this.exportService(remoteServiceAdmin, sref);
            repo.addService(sref, regs);
        }
    }

    private Collection<ExportRegistration> exportService(RemoteServiceAdmin rsa, ServiceReference<?> sref) {
        if (sref.getBundle() == null) {
            LOG.info("TopologyManager: export aborted for {} since it was unregistered", sref);
            return Collections.emptyList();
        }
        LOG.debug("exporting Service {} using RemoteServiceAdmin {}", sref, (Object)rsa.getClass().getName());
        Map addProps = this.policy.additionalParameters(sref);
        Collection exportRegs = rsa.exportService(sref, addProps);
        for (ExportRegistration reg : exportRegs) {
            if (reg.getException() == null) {
                EndpointDescription endpoint = reg.getExportReference().getExportedEndpoint();
                LOG.info("TopologyManager: export succeeded for {}, endpoint {}, rsa {}", new Object[]{sref, endpoint, rsa.getClass().getName()});
                continue;
            }
            LOG.error("TopologyManager: export failed for {}", sref, (Object)reg.getException());
            reg.close();
        }
        if (sref.getBundle() == null) {
            LOG.info("TopologyManager: export reverted for {} since service was unregistered", sref);
            for (ExportRegistration reg : exportRegs) {
                reg.close();
            }
        }
        return exportRegs;
    }

    private boolean shouldExport(ServiceReference<?> sref) {
        Map addProps = this.policy.additionalParameters(sref);
        List exported = StringPlus.normalize((Object)sref.getProperty("service.exported.interfaces"));
        List addExported = StringPlus.normalize(addProps.get("service.exported.interfaces"));
        return this.sizeOf(exported) + this.sizeOf(addExported) > 0;
    }

    private int sizeOf(List<String> list) {
        return list == null ? 0 : list.size();
    }

    private Object getSymbolicName(Bundle bundle) {
        return bundle == null ? null : bundle.getSymbolicName();
    }

    public void addEPListener(EndpointEventListener epListener, Set<Filter> filters) {
        ArrayList<EndpointDescription> endpoints = new ArrayList<EndpointDescription>();
        for (RemoteServiceAdmin rsa : this.endpointRepo.keySet()) {
            ServiceExportsRepository repo = this.endpointRepo.get(rsa);
            endpoints.addAll(repo.getAllEndpoints());
        }
        this.notifier.add(epListener, filters, endpoints);
    }

    public void removeEPListener(EndpointEventListener listener) {
        this.notifier.remove(listener);
    }
}

