/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.importer.local;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FilterHelper {
    private static final String OBJECTCLASS_EXPRESSION = ".*\\(objectClass=([^)]+)\\).*";
    private static final Pattern OBJECTCLASS_PATTERN = Pattern.compile(".*\\(objectClass=([^)]+)\\).*");
    private static final Set<String> SYSTEM_PACKAGES = new HashSet<String>();

    private FilterHelper() {
    }

    public static String getObjectClass(String filter) {
        Matcher matcher;
        if (filter != null && (matcher = OBJECTCLASS_PATTERN.matcher(filter)).matches() && matcher.groupCount() >= 1) {
            return matcher.group(1);
        }
        return null;
    }

    public static boolean isClassExcluded(String className) {
        if (className == null) {
            return true;
        }
        if (className.startsWith("org.osgi.service.clusterinfo")) {
            return false;
        }
        for (String p : SYSTEM_PACKAGES) {
            if (!className.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public static String getFullFilter(String objectClass, String filter) {
        if (objectClass == null) {
            return filter;
        }
        String nameFilter = String.format("(objectClass=%s)", objectClass);
        return filter == null ? nameFilter : String.format("(&%s%s)", nameFilter, filter);
    }

    static {
        SYSTEM_PACKAGES.add("org.osgi.service");
        SYSTEM_PACKAGES.add("org.apache.felix");
        SYSTEM_PACKAGES.add("org.ops4j.pax.logging");
        SYSTEM_PACKAGES.add("ch.ethz.iks.slp");
        SYSTEM_PACKAGES.add("org.ungoverned.osgi.service");
        SYSTEM_PACKAGES.add("org.springframework.osgi.context.event.OsgiBundleApplicationContextListener");
        SYSTEM_PACKAGES.add("java.net.ContentHandler");
    }
}

