/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.tools.connector.influxdb;

import java.net.URI;

public class InfluxDbConnectorConfiguration {
    public static final String DEFAULT_SCHEME = "http";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PATH = "";
    public static final int DEFAULT_PORT = 8086;
    private String username;
    private String password;
    private String scheme;
    private String host;
    private int port;
    private String path;

    private InfluxDbConnectorConfiguration() {
        this(DEFAULT_SCHEME, DEFAULT_HOST, 8086, DEFAULT_PATH);
    }

    private InfluxDbConnectorConfiguration(String scheme, String host, int port, String path) {
        this.scheme = scheme;
        this.port = port;
        this.host = host;
        this.path = path;
    }

    private InfluxDbConnectorConfiguration(String username, String password, String scheme, String host, int port, String path) {
        this(scheme, host, port, path);
        this.username = username;
        this.password = password;
    }

    private void setPath(String path) {
        this.path = path;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUri() {
        String port = null;
        port = this.port <= 0 ? DEFAULT_PATH : ":".concat(String.valueOf(this.port));
        String uri = String.format("%s://%s%s%s", this.scheme, this.host, port, this.path);
        return uri;
    }

    public static class Builder {
        String username;
        String password;
        String scheme;
        String host;
        int port;
        String path;

        public Builder withUsername(String username) {
            String user;
            if (username != null && (user = username.trim()).length() > 0) {
                this.username = user;
            }
            return this;
        }

        public Builder withPassword(String password) {
            String pass;
            if (password != null && (pass = password.trim()).length() > 0) {
                this.password = pass;
            }
            return this;
        }

        public Builder withUri(String uri) {
            if (uri != null) {
                URI u = URI.create(uri);
                this.scheme = u.getScheme();
                this.host = u.getHost();
                this.port = u.getPort();
                this.path = u.getPath();
            }
            return this;
        }

        public Builder withHost(String host) {
            String h;
            if (host != null && (h = host.trim()).length() > 0) {
                this.host = h;
            }
            return this;
        }

        public Builder withPort(int port) {
            if (port > 0) {
                this.port = port;
            }
            return this;
        }

        public Builder withPath(String path) {
            String p;
            if (path != null && (p = path.trim()).length() > 0) {
                this.path = p;
            }
            return this;
        }

        private String getPath() {
            if (this.path == null) {
                return InfluxDbConnectorConfiguration.DEFAULT_PATH;
            }
            return this.path;
        }

        public Builder withScheme(String scheme) {
            String s;
            if (scheme != null && (s = scheme.trim()).length() > 0) {
                this.scheme = s;
            }
            return this;
        }

        public InfluxDbConnectorConfiguration build() {
            InfluxDbConnectorConfiguration config;
            if (this.host == null && this.port == 0 && (this.username == null || this.password == null)) {
                config = new InfluxDbConnectorConfiguration();
                config.setPath(this.getPath());
            } else {
                if (this.scheme == null) {
                    this.scheme = InfluxDbConnectorConfiguration.DEFAULT_SCHEME;
                }
                if (this.host == null) {
                    this.host = InfluxDbConnectorConfiguration.DEFAULT_HOST;
                }
                if (this.port == 0) {
                    this.port = 8086;
                }
                config = this.username != null && this.password != null ? new InfluxDbConnectorConfiguration(this.username, this.password, this.scheme, this.host, this.port, this.getPath()) : new InfluxDbConnectorConfiguration(this.scheme, this.host, this.port, this.getPath());
            }
            return config;
        }
    }
}

