/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.method.ActMethod;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.method.Shortcut;
import org.eclipse.sensinact.gateway.core.method.Signature;

public class LinkedActMethod
extends ActMethod {
    private final ActMethod linked;

    public LinkedActMethod(Mediator mediator, String uri, ActMethod linked, boolean copyActMethod) {
        super(mediator, uri, linked != null ? linked.preProcessingExecutor : null);
        this.linked = linked;
        if (copyActMethod && linked != null) {
            this.linkedSignatures();
        }
    }

    private final void linkedSignatures() {
        if (this.linked == null) {
            return;
        }
        for (Map.Entry entry : this.linked.map.entrySet()) {
            this.map.put((Signature)((Signature)entry.getKey()).clone(), new LinkedList((Collection)entry.getValue()));
        }
        for (Map.Entry entry : this.linked.shortcuts.entrySet()) {
            this.shortcuts.put((Shortcut)((Shortcut)entry.getKey()).clone(), (Shortcut)((Signature)entry.getValue()).clone());
        }
    }

    public final Signature linkedSignature(Signature signature) {
        Signature thatSignature = null;
        if (this.linked == null || signature == null || signature.getName().intern() != super.getName().intern() || (thatSignature = this.linked.getSignature(signature.getParameterTypes())) == null) {
            return null;
        }
        Deque executors = (Deque)this.linked.map.get(thatSignature);
        LinkedList<Signature> chain = new LinkedList<Signature>();
        Signature shortcut = thatSignature;
        Signature reference = null;
        if (executors == null) {
            while ((reference = (Signature)this.linked.shortcuts.get(shortcut)) != null) {
                chain.add(shortcut);
                shortcut = reference;
            }
            executors = (Deque)this.linked.map.get(shortcut);
            if (executors == null) {
                return null;
            }
        }
        shortcut = (Signature)shortcut.clone();
        this.map.put(shortcut, new LinkedList(executors));
        while (!chain.isEmpty()) {
            reference = shortcut;
            shortcut = (Signature)((Signature)chain.removeLast()).clone();
            this.shortcuts.put((Shortcut)shortcut, reference);
        }
        return shortcut;
    }

    public final void createShortcut(Signature signature, Shortcut shortcut) throws InvalidValueException {
        Signature thatSignature = null;
        if (this.linked == null || signature == null || signature.getName().intern() != super.getName().intern() || (thatSignature = this.linked.getSignature(signature.getParameterTypes())) == null) {
            return;
        }
        Deque executors = (Deque)this.linked.map.get(thatSignature);
        HashMap<Integer, Parameter> fixedParameters = new HashMap<Integer, Parameter>();
        fixedParameters.putAll(shortcut.getFixedParameters());
        Signature thatShortcut = thatSignature;
        Signature reference = null;
        if (executors == null) {
            while ((reference = (Signature)this.linked.shortcuts.get(thatShortcut)) != null) {
                fixedParameters.putAll(((Shortcut)thatShortcut).getFixedParameters());
                thatShortcut = reference;
            }
            executors = (Deque)this.linked.map.get(thatShortcut);
            if (executors == null) {
                return;
            }
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Iterator<Parameter> iterator = shortcut.iterator();
        while (iterator.hasNext()) {
            parameters.add(iterator.next());
        }
        this.map.put(new Shortcut(this.mediator, signature.getName(), parameters.toArray(new Parameter[parameters.size()]), fixedParameters), new LinkedList(executors));
    }
}

