/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sensinact.gateway.app.api.persistence.ApplicationPersistenceService;
import org.eclipse.sensinact.gateway.app.api.persistence.dao.Application;
import org.eclipse.sensinact.gateway.app.api.persistence.exception.ApplicationPersistenceException;
import org.eclipse.sensinact.gateway.app.api.persistence.listener.ApplicationAvailabilityListener;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ApplicationPersistenceService.class}, scope=ServiceScope.SINGLETON, configurationPolicy=ConfigurationPolicy.REQUIRE)
@ServiceRanking(value=500)
public class InMemoryApplicationPersistenceService
implements ApplicationPersistenceService {
    private static Logger LOG = LoggerFactory.getLogger(InMemoryApplicationPersistenceService.class);
    private List<Application> applications = new ArrayList<Application>();
    private final Set<ApplicationAvailabilityListener> listeners = new HashSet<ApplicationAvailabilityListener>();

    @Activate
    public void activate() {
        this.notifyServiceAvailable();
    }

    private Application findApplication(String name) {
        for (Application application : this.applications) {
            if (!application.getName().equals(name)) continue;
            return application;
        }
        return null;
    }

    @Override
    public void persist(Application application) throws ApplicationPersistenceException {
        Application applicationStored = this.findApplication(application.getName());
        if (applicationStored == null) {
            this.applications.add(application);
            this.notifyInclusion(application);
        } else if (!application.getDiggest().equals(applicationStored.getDiggest())) {
            this.applications.remove(applicationStored);
            this.applications.add(application);
            this.notifyModification(application);
        }
    }

    @Override
    public void delete(String applicationName) throws ApplicationPersistenceException {
        this.notifyRemoval(this.findApplication(applicationName));
        this.applications.remove(this.findApplication(applicationName));
    }

    @Override
    public JSONObject fetch(String applicationName) throws ApplicationPersistenceException {
        return this.findApplication(applicationName).getContent();
    }

    @Override
    public Collection<Application> list() {
        return this.applications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServiceAvailabilityListener(ApplicationAvailabilityListener listenerClient) {
        Set<ApplicationAvailabilityListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listenerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterServiceAvailabilityListener(ApplicationAvailabilityListener listenerClient) {
        Set<ApplicationAvailabilityListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listenerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInclusion(Application application) {
        if (application == null) {
            return;
        }
        try {
            LOG.info("Notifying application '{}' inclusion ", (Object)application.getName());
            for (ApplicationAvailabilityListener list : new HashSet<ApplicationAvailabilityListener>(this.listeners)) {
                try {
                    ApplicationAvailabilityListener applicationAvailabilityListener = list;
                    synchronized (applicationAvailabilityListener) {
                        list.applicationFound(application.getName(), application.getContent().toString());
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to add application {} into the platform, is ApplicationManager running?", (Object)application.getName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load application", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyModification(Application application) {
        if (application == null) {
            return;
        }
        try {
            LOG.info("Notifying application '{}' modification ", (Object)application.getName());
            for (ApplicationAvailabilityListener list : new HashSet<ApplicationAvailabilityListener>(this.listeners)) {
                try {
                    ApplicationAvailabilityListener applicationAvailabilityListener = list;
                    synchronized (applicationAvailabilityListener) {
                        list.applicationChanged(application.getName(), application.getContent().toString());
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to add application {} into the platform, is ApplicationManager running?", (Object)application.getName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load application", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRemoval(Application application) {
        if (application == null) {
            return;
        }
        try {
            LOG.info("Notifying application '{}' removal ", (Object)application.getName());
            for (ApplicationAvailabilityListener list : new HashSet<ApplicationAvailabilityListener>(this.listeners)) {
                try {
                    ApplicationAvailabilityListener applicationAvailabilityListener = list;
                    synchronized (applicationAvailabilityListener) {
                        list.applicationRemoved(application.getName());
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to add application {} into the platform, is ApplicationManager running?", (Object)application.getName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load application", (Throwable)e);
        }
    }

    private void notifyServiceUnavailable() {
        LOG.debug("Memory Persistence service is going offline");
        for (ApplicationAvailabilityListener list : new HashSet<ApplicationAvailabilityListener>(this.listeners)) {
            try {
                list.serviceOffline();
            }
            catch (Exception e) {
                LOG.error("Memory Persistence service is going offline", (Throwable)e);
            }
        }
    }

    private void notifyServiceAvailable() {
        LOG.debug("Memory Persistence service is going online");
        for (ApplicationAvailabilityListener listener : new HashSet<ApplicationAvailabilityListener>(this.listeners)) {
            try {
                listener.serviceOnline();
            }
            catch (Exception e) {
                LOG.error("Memory Persistence service is going online", (Throwable)e);
            }
        }
    }
}

