/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.api.lifecycle;

import org.eclipse.sensinact.gateway.common.primitive.JSONable;

public enum ApplicationStatus implements JSONable
{
    INSTALLED("INSTALLED"),
    RESOLVING("RESOLVING"),
    UNRESOLVED("UNRESOLVED"),
    ACTIVE("ACTIVE"),
    UNINSTALLED("UNINSTALLED");

    private String value;

    private ApplicationStatus(String value) {
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationStatus getNextStatus(ApplicationStatus currentStatus, String action, boolean hasErrors) {
        if ("START".equals(action)) {
            if (hasErrors) return UNRESOLVED;
            if (INSTALLED.equals((Object)currentStatus) || UNRESOLVED.equals((Object)currentStatus)) {
                return RESOLVING;
            }
            if (!currentStatus.equals((Object)RESOLVING)) return currentStatus;
            return ACTIVE;
        }
        if ("UNINSTALL".equals(action)) {
            if (!INSTALLED.equals((Object)currentStatus) && !UNRESOLVED.equals((Object)currentStatus)) return currentStatus;
            return UNINSTALLED;
        }
        if ("STOP".equals(action)) {
            if (!ACTIVE.equals((Object)currentStatus)) return currentStatus;
            return INSTALLED;
        }
        if (!"EXCEPTION".equals(action) || !ACTIVE.equals((Object)currentStatus)) return currentStatus;
        return UNRESOLVED;
    }

    public String getJSON() {
        return this.value;
    }
}

