/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.sensinact.gateway.app.api.function.DataItf;
import org.eclipse.sensinact.gateway.app.manager.component.DataListenerItf;
import org.eclipse.sensinact.gateway.app.manager.component.DataProviderItf;
import org.eclipse.sensinact.gateway.app.manager.component.Event;
import org.eclipse.sensinact.gateway.app.manager.component.data.Data;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;

public abstract class AbstractDataProvider
implements DataProviderItf {
    private final String uri;
    private final Map<DataListenerItf, Set<Constraint>> listeners;
    private Data data;

    AbstractDataProvider(String uri) {
        this.uri = uri;
        this.listeners = new HashMap<DataListenerItf, Set<Constraint>>();
        this.data = null;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public DataItf getData() {
        return this.data;
    }

    public abstract Class<?> getDataType();

    @Override
    public void addListener(DataListenerItf listener, Set<Constraint> constraints) {
        this.listeners.put(listener, constraints);
    }

    @Override
    public void removeListener(DataListenerItf listener) {
        this.listeners.remove(listener);
    }

    public void updateAndNotify(UUID eventUuid, Object value, List<String> route) {
        this.data = new Data(new UUID(System.currentTimeMillis(), System.currentTimeMillis()), this.uri, this.getDataType(), value, System.currentTimeMillis());
        route.add(this.uri);
        Event event = new Event(eventUuid, this.data, route);
        for (Map.Entry<DataListenerItf, Set<Constraint>> listener : this.listeners.entrySet()) {
            boolean comply = true;
            if (listener.getValue() != null) {
                for (Constraint constraint : listener.getValue()) {
                    if (constraint.complies(value)) continue;
                    comply = false;
                    break;
                }
            }
            if (!comply) continue;
            listener.getKey().eventNotification(event);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDataProvider that = (AbstractDataProvider)o;
        return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
    }

    public int hashCode() {
        return this.uri != null ? this.uri.hashCode() : 0;
    }
}

