/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.tools.connector.influxdb;

import java.io.IOException;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbConnectorConfiguration;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbDatabase;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Pong;

public class InfluxDbConnector {
    private InfluxDB influxDB;

    public InfluxDbConnector() throws IOException {
        this(new InfluxDbConnectorConfiguration.Builder().build());
    }

    public InfluxDbConnector(InfluxDbConnectorConfiguration configuration) throws IOException {
        boolean connected = false;
        connected = configuration.getUserName() != null && configuration.getPassword() != null ? this.connect(configuration.getUri(), configuration.getUserName(), configuration.getPassword()) : this.connect(configuration.getUri());
        if (!connected) {
            throw new IOException("Unable to connect");
        }
        this.influxDB.setLogLevel(InfluxDB.LogLevel.NONE);
        this.influxDB.enableBatch();
    }

    private boolean connect(String uri) {
        this.influxDB = InfluxDBFactory.connect(uri);
        return this.checkVersion();
    }

    private boolean connect(String uri, String username, String password) {
        this.influxDB = InfluxDBFactory.connect(uri, username, password);
        return this.checkVersion();
    }

    private boolean checkVersion() {
        Pong response = this.influxDB.ping();
        if (!response.isGood()) {
            System.out.println("Error pinging server.");
            this.influxDB.close();
            this.influxDB = null;
            return false;
        }
        return true;
    }

    public boolean exists(String databaseName) {
        return this.influxDB.databaseExists(databaseName);
    }

    public InfluxDbDatabase createIfNotExists(String databaseName) {
        if (!this.exists(databaseName)) {
            this.influxDB.createDatabase(databaseName);
        }
        return new InfluxDbDatabase(this.influxDB, databaseName);
    }

    public InfluxDbDatabase getIfExists(String databaseName) {
        if (!this.exists(databaseName)) {
            return null;
        }
        return new InfluxDbDatabase(this.influxDB, databaseName);
    }

    public InfluxDbDatabase getIfExists(String databaseName, String retentionPolicy) {
        if (!this.exists(databaseName)) {
            return null;
        }
        return new InfluxDbDatabase(this.influxDB, databaseName, retentionPolicy);
    }
}

