/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.RequirementBuilder;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceConfigBuilder;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.TypeConfig;

public class DefaultResourceConfigBuilder
implements ResourceConfigBuilder {
    private Class<? extends Resource> defaultResourceType;
    private Class<?> defaultDataType;
    private Modifiable defaultModifiable;
    private Resource.UpdatePolicy defaultUpdatePolicy;

    public ResourceConfig getResourceConfig(ResourceDescriptor resourceDescriptor) {
        Class<? extends Resource> resourceType = resourceDescriptor.resourceType() == null ? this.getDefaultResourceType() : resourceDescriptor.resourceType();
        Class<? extends ResourceConfig> resourceConfigType = resourceDescriptor.resourceConfigType();
        Class<? extends ResourceImpl> resourceImplementationType = resourceDescriptor.resourceImplementationType();
        ResourceConfig resourceConfig = null;
        try {
            resourceConfig = resourceConfigType.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        TypeConfig typeConfig = new TypeConfig(resourceType);
        typeConfig.setImplementationClass(resourceImplementationType);
        resourceConfig.setTypeConfig(typeConfig);
        if (ActionResource.class.isAssignableFrom(resourceType)) {
            return resourceConfig;
        }
        if (resourceDescriptor.updatePolicy() != null) {
            resourceConfig.setUpdatePolicy(resourceDescriptor.updatePolicy());
        } else {
            resourceConfig.setUpdatePolicy(this.getDefaultUpdatePolicy());
        }
        RequirementBuilder requirementBuider = new RequirementBuilder(AttributeBuilder.Requirement.MODIFIABLE, resourceDescriptor.resourceName());
        if (resourceDescriptor.modifiable() == null) {
            requirementBuider.put(resourceDescriptor.serviceName(), this.getDefaultModifiable());
            resourceDescriptor.withModifiable(this.getDefaultModifiable());
        } else {
            requirementBuider.put(resourceDescriptor.serviceName(), resourceDescriptor.modifiable());
        }
        resourceConfig.addRequirementBuilder(requirementBuider);
        requirementBuider = new RequirementBuilder(AttributeBuilder.Requirement.TYPE, resourceDescriptor.resourceName());
        if (resourceDescriptor.dataType() == null) {
            requirementBuider.put(resourceDescriptor.serviceName(), this.getDefaultDataType());
            resourceDescriptor.withDataType(this.getDefaultDataType());
        } else {
            requirementBuider.put(resourceDescriptor.serviceName(), resourceDescriptor.dataType());
        }
        resourceConfig.addRequirementBuilder(requirementBuider);
        return resourceConfig;
    }

    private Class<? extends Resource> getDefaultResourceType() {
        if (this.defaultResourceType == null) {
            return RESOURCE_TYPE;
        }
        return this.defaultResourceType;
    }

    @Override
    public void setDefaultResourceType(Class<? extends Resource> defaultResourceType) {
        this.defaultResourceType = defaultResourceType;
    }

    private Class<?> getDefaultDataType() {
        if (this.defaultDataType == null) {
            return DATA_TYPE;
        }
        return this.defaultDataType;
    }

    @Override
    public void setDefaultDataType(Class<?> defaultDataType) {
        this.defaultDataType = defaultDataType;
    }

    private Modifiable getDefaultModifiable() {
        if (this.defaultModifiable == null) {
            return MODIFIABLE;
        }
        return this.defaultModifiable;
    }

    @Override
    public void setDefaultModifiable(Modifiable defaultModifiable) {
        this.defaultModifiable = defaultModifiable;
    }

    private Resource.UpdatePolicy getDefaultUpdatePolicy() {
        if (this.defaultUpdatePolicy == null) {
            return UPDATE_POLICY;
        }
        return this.defaultUpdatePolicy;
    }

    @Override
    public void setDefaultUpdatePolicy(Resource.UpdatePolicy defaultUpdatePolicy) {
        this.defaultUpdatePolicy = defaultUpdatePolicy;
    }
}

