/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.InvalidServiceException;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceBuilder.class);
    private Mediator mediator;
    protected final Class<? extends ServiceImpl> baseClass;
    private Class<? extends ServiceImpl> implementationClass;
    private String name;

    public ServiceBuilder(Mediator mediator) {
        this(mediator, ServiceImpl.class);
    }

    public ServiceBuilder(Mediator mediator, Class<? extends ServiceImpl> baseClass) {
        this.mediator = mediator;
        this.baseClass = baseClass;
    }

    public void configureName(String name) {
        this.name = name;
    }

    public String getConfiguredName() {
        return this.name;
    }

    public void configureImplementationClass(Class<? extends ServiceImpl> implementationClass) {
        this.implementationClass = implementationClass;
    }

    public final <E extends ServiceImpl, F extends ServiceImpl> ServiceImpl build(ModelInstance<?> snaModelInstance, ServiceProviderImpl provider) throws InvalidServiceException {
        if (this.name == null) {
            throw new InvalidServiceException("Service's name is needed");
        }
        ServiceImpl serviceImpl = null;
        try {
            serviceImpl = (ServiceImpl)ReflectUtils.getInstance(this.baseClass, this.implementationClass == null ? ServiceImpl.class : this.implementationClass, (Object[])new Object[]{snaModelInstance, this.name, provider});
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new InvalidServiceException(e.getMessage(), e);
        }
        return serviceImpl;
    }
}

