/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.InvalidServiceException;
import org.eclipse.sensinact.gateway.core.ModelElementProxy;
import org.eclipse.sensinact.gateway.core.Service;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.ServiceAccessMethod;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.eclipse.sensinact.gateway.core.method.UnaccessibleAccessMethod;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;

public class ServiceProxy
extends ModelElementProxy {
    protected final Map<String, AccessMethod<?, ?>> methods = new HashMap();

    ServiceProxy(Mediator mediator, String path) throws InvalidServiceException {
        super(mediator, Service.class, path);
    }

    @Override
    public AccessMethod<?, ?> getAccessMethod(String method) {
        return this.methods.get(method);
    }

    void registerMethod(String methodType, AccessMethod<?, ?> method) {
        if (this.methods.get(methodType) == null) {
            this.methods.put(methodType, method);
        }
    }

    final void buildMethods(ErrorHandler handler, List<MethodAccessibility> methodAccessibilities) throws InvalidValueException {
        UnaccessibleAccessMethod snaMethod;
        int length = methodAccessibilities == null ? 0 : methodAccessibilities.size();
        ServiceAccessMethod getMethod = null;
        ServiceAccessMethod setMethod = null;
        ServiceAccessMethod subscribeMethod = null;
        ServiceAccessMethod unsubscribeMethod = null;
        ServiceAccessMethod actMethod = null;
        block16: for (int index = 0; index < length; ++index) {
            MethodAccessibility methodAccessibility = methodAccessibilities.get(index);
            if (!methodAccessibility.isAccessible()) continue;
            switch (methodAccessibility.getMethod().name()) {
                case "ACT": {
                    actMethod = new ServiceAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.ACT), handler);
                    continue block16;
                }
                case "DESCRIBE": {
                    continue block16;
                }
                case "GET": {
                    getMethod = new ServiceAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.GET), handler);
                    continue block16;
                }
                case "SET": {
                    setMethod = new ServiceAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.SET), handler);
                    continue block16;
                }
                case "SUBSCRIBE": {
                    subscribeMethod = new ServiceAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.SUBSCRIBE), handler);
                    continue block16;
                }
                case "UNSUBSCRIBE": {
                    unsubscribeMethod = new ServiceAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.UNSUBSCRIBE), handler);
                    continue block16;
                }
            }
        }
        AccessMethod.Type GET = AccessMethod.Type.valueOf(AccessMethod.GET);
        AccessMethod.Type SET = AccessMethod.Type.valueOf(AccessMethod.SET);
        AccessMethod.Type ACT = AccessMethod.Type.valueOf(AccessMethod.ACT);
        AccessMethod.Type SUBSCRIBE = AccessMethod.Type.valueOf(AccessMethod.SUBSCRIBE);
        AccessMethod.Type UNSUBSCRIBE = AccessMethod.Type.valueOf(AccessMethod.UNSUBSCRIBE);
        AccessMethod.Type DESCRIBE = AccessMethod.Type.valueOf(AccessMethod.DESCRIBE);
        Signature getSignature = new Signature(this.mediator, GET, new Class[]{String.class, String.class}, new String[]{"resourceName", "attributeName"});
        Signature setSignature = new Signature(this.mediator, SET, new Class[]{String.class, String.class, Object.class}, new String[]{"resourceName", "attributeName", "value"});
        Signature actSignature = new Signature(this.mediator, ACT, new Class[]{String.class, Object[].class}, new String[]{"resourceName", "arguments"});
        Signature subscribeSignature = new Signature(this.mediator, SUBSCRIBE, new Class[]{String.class, String.class, Recipient.class, Set.class, String.class}, new String[]{"resourceName", "attributeName", "listener", "conditions", "policy"});
        Signature unsubscribeSignature = new Signature(this.mediator, UNSUBSCRIBE, new Class[]{String.class, String.class, String.class}, new String[]{"resourceName", "attributeName", "subscriptionId"});
        if (getMethod != null) {
            getMethod.addSignature(getSignature);
            this.registerMethod(AccessMethod.GET, getMethod);
        } else {
            snaMethod = new UnaccessibleAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.GET));
            this.registerMethod(AccessMethod.GET, snaMethod);
        }
        if (setMethod != null) {
            setMethod.addSignature(setSignature);
            this.registerMethod(AccessMethod.SET, setMethod);
        } else {
            snaMethod = new UnaccessibleAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.SET));
            this.registerMethod(AccessMethod.SET, snaMethod);
        }
        if (actMethod != null) {
            actMethod.addSignature(actSignature);
            this.registerMethod(AccessMethod.ACT, actMethod);
        } else {
            snaMethod = new UnaccessibleAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.ACT));
            this.registerMethod(AccessMethod.ACT, snaMethod);
        }
        if (subscribeMethod != null) {
            subscribeMethod.addSignature(subscribeSignature);
            Signature subscribePolicyShortcut = new Signature(this.mediator, SUBSCRIBE, new Class[]{String.class, String.class, Recipient.class, Set.class}, new String[]{"resourceName", "attributeName", "listener", "conditions"});
            Signature subscribeConditionsPolicyShortcut = new Signature(this.mediator, SUBSCRIBE, new Class[]{String.class, String.class, Recipient.class}, new String[]{"resourceName", "attributeName", "listener"});
            subscribeMethod.addSignature(subscribePolicyShortcut);
            subscribeMethod.addSignature(subscribeConditionsPolicyShortcut);
            this.registerMethod(AccessMethod.SUBSCRIBE, subscribeMethod);
        } else {
            snaMethod = new UnaccessibleAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.SUBSCRIBE));
            this.registerMethod(AccessMethod.SUBSCRIBE, snaMethod);
        }
        if (unsubscribeMethod != null) {
            unsubscribeMethod.addSignature(unsubscribeSignature);
            Signature unsubscribeNameShortcut = new Signature(this.mediator, UNSUBSCRIBE, new Class[]{String.class, String.class, String.class}, new String[]{"resourceName", "attributeName", "subscriptionId"});
            unsubscribeMethod.addSignature(unsubscribeNameShortcut);
            this.registerMethod(AccessMethod.UNSUBSCRIBE, unsubscribeMethod);
        } else {
            snaMethod = new UnaccessibleAccessMethod(this.mediator, this.getPath(), AccessMethod.Type.valueOf(AccessMethod.UNSUBSCRIBE));
            this.registerMethod(AccessMethod.UNSUBSCRIBE, snaMethod);
        }
    }
}

