/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method.builder;

import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintConstantPair;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.method.builder.AbstractDynamicParameterValue;
import org.eclipse.sensinact.gateway.util.JSONUtils;

public class ConditionalConstant
extends AbstractDynamicParameterValue {
    public static final String NAME = "CONDITIONAL";
    private List<ConstraintConstantPair> constants;

    public ConditionalConstant(Mediator mediator, String parameterName, String resourceName, List<ConstraintConstantPair> constraints) throws InvalidValueException {
        super(mediator, parameterName, resourceName);
        this.constants = constraints;
    }

    public String getJSON() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append('\"');
        buffer.append("type");
        buffer.append('\"');
        buffer.append(':');
        buffer.append('\"');
        buffer.append(this.getName());
        buffer.append('\"');
        buffer.append(',');
        buffer.append('\"');
        buffer.append("parameter");
        buffer.append('\"');
        buffer.append(':');
        buffer.append('\"');
        buffer.append(this.parameterName);
        buffer.append('\"');
        buffer.append(',');
        buffer.append('\"');
        buffer.append("resource");
        buffer.append('\"');
        buffer.append(':');
        buffer.append('\"');
        buffer.append(this.resourceName);
        buffer.append('\"');
        buffer.append(',');
        buffer.append('\"');
        buffer.append("constants");
        buffer.append('\"');
        buffer.append(':');
        buffer.append('[');
        if (this.constants != null) {
            Iterator<ConstraintConstantPair> iterator = this.constants.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                ConstraintConstantPair entry = iterator.next();
                buffer.append(index > 0 ? Character.valueOf(',') : "");
                buffer.append('{');
                buffer.append('\"');
                buffer.append("constant");
                buffer.append('\"');
                buffer.append(':');
                buffer.append(JSONUtils.toJSONFormat((Object)entry.constant));
                buffer.append(',');
                buffer.append('\"');
                buffer.append("constraint");
                buffer.append('\"');
                buffer.append(':');
                buffer.append(entry.constraint.getJSON());
                buffer.append('}');
                ++index;
            }
        }
        buffer.append(']');
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getResource() {
        return this.resourceName;
    }

    @Override
    public Object getValue() {
        if (this.constants == null) {
            return null;
        }
        Object object = this.getResourceValue();
        for (ConstraintConstantPair entry : this.constants) {
            if (!entry.constraint.complies(object)) continue;
            return entry.constant;
        }
        return null;
    }
}

