/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security;

import java.util.Iterator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.security.AccessNodeImpl;
import org.eclipse.sensinact.gateway.core.security.AccessProfile;
import org.eclipse.sensinact.gateway.core.security.AccessProfileOption;
import org.eclipse.sensinact.gateway.core.security.ImmutableAccessNode;
import org.eclipse.sensinact.gateway.core.security.ImmutableAccessTree;
import org.eclipse.sensinact.gateway.core.security.MutableAccessTree;
import org.eclipse.sensinact.gateway.util.tree.PathNode;
import org.eclipse.sensinact.gateway.util.tree.PathNodeFactory;
import org.eclipse.sensinact.gateway.util.tree.PathTree;

public class AccessTreeImpl<N extends AccessNodeImpl<N>>
extends PathTree<N>
implements MutableAccessTree<AccessNodeImpl<N>> {
    protected Mediator mediator;

    public AccessTreeImpl() {
        super(new AccessNodeFactory());
    }

    public MutableAccessTree<AccessNodeImpl<N>> withAccessProfile(AccessProfileOption option) {
        return this.withAccessProfile(option.getAccessProfile());
    }

    @Override
    public MutableAccessTree<AccessNodeImpl<N>> withAccessProfile(AccessProfile profile) {
        ((AccessNodeImpl)this.root).withAccessProfile(profile);
        return this;
    }

    @Override
    public MutableAccessTree<AccessNodeImpl<N>> clone() {
        MutableAccessTree<AccessNodeImpl<N>> tree = new AccessTreeImpl<N>().withAccessProfile(((AccessNodeImpl)this.getRoot()).getProfile());
        Iterator iterator = ((AccessNodeImpl)this.getRoot()).iterator();
        while (iterator.hasNext()) {
            ((AccessNodeImpl)tree.getRoot()).add((PathNode)((AccessNodeImpl)iterator.next()).clone());
        }
        return tree;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public ImmutableAccessTree immutable() {
        return (ImmutableAccessTree)super.immutable(ImmutableAccessTree.class, ImmutableAccessNode.class);
    }

    private static class AccessNodeFactory<N extends AccessNodeImpl<N>>
    implements PathNodeFactory<N> {
        private AccessNodeFactory() {
        }

        public N createPathNode(String nodeName) {
            return (N)new AccessNodeImpl(nodeName, false);
        }

        public N createPatternNode(String nodeName) {
            return (N)new AccessNodeImpl(nodeName, true);
        }

        public N createRootNode() {
            return (N)new AccessNodeImpl("/", false);
        }
    }
}

