/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao;

import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.core.security.AccessProfileOption;
import org.eclipse.sensinact.gateway.core.security.dao.AbstractImmutableSnaDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.dao.ObjectProfileDAO;
import org.eclipse.sensinact.gateway.core.security.entity.ObjectProfileAccessEntity;
import org.eclipse.sensinact.gateway.core.security.entity.ObjectProfileEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;

public class ObjectProfileAccessDAO
extends AbstractImmutableSnaDAO<ObjectProfileAccessEntity> {
    private ObjectProfileDAO objectProfileDAO;

    public ObjectProfileAccessDAO(DataStoreService dataStoreService) throws DAOException {
        super(ObjectProfileAccessEntity.class, dataStoreService);
        this.objectProfileDAO = new ObjectProfileDAO(dataStoreService);
    }

    public AccessProfileOption getAccessProfileOption(long objectProfile) throws DAOException, DataStoreException {
        ObjectProfileEntity entity = this.objectProfileDAO.find(objectProfile);
        return AccessProfileOption.valueOf((String)entity.getName());
    }

    public List<ObjectProfileAccessEntity> getObjectProfileAccesses(ObjectProfileEntity objectProfileEntity) throws DAOException, DataStoreException {
        return this.getObjectProfileAccesses(objectProfileEntity.getIdentifier());
    }

    public List<ObjectProfileAccessEntity> getObjectProfileAccesses(long identifier) throws DAOException, DataStoreException {
        return super.select(Collections.singletonMap("OPID", identifier));
    }
}

