/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.commands.gogo.internal;

import java.io.IOException;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.sensinact.gateway.commands.gogo.internal.shell.ShellAccess;
import org.eclipse.sensinact.gateway.commands.gogo.internal.shell.ShellAccessRequest;
import org.eclipse.sensinact.gateway.commands.gogo.osgi.CommandServiceMediator;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestBuilder;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.format.JSONResponseFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessMethodCommands {
    private static final Logger LOG = LoggerFactory.getLogger(AccessMethodCommands.class);
    private CommandServiceMediator mediator;

    public AccessMethodCommands(CommandServiceMediator mediator) {
        this.mediator = mediator;
    }

    @Descriptor(value="get the description of a specific method of a resource of a sensiNact service")
    public void method(@Descriptor(value="the service provider ID") String serviceProviderID, @Descriptor(value="the service ID") String serviceID, @Descriptor(value="the resource ID") String resourceID, final @Descriptor(value="the method type") String methodType) throws InvalidCredentialException, JSONException, IOException {
        new ShellAccess(new ShellAccessRequest(this.mediator, new JSONObject().put("uri", (Object)CommandServiceMediator.uri(serviceProviderID, serviceID, resourceID, false)))){

            @Override
            protected boolean respond(NorthboundMediator mediator, NorthboundRequestBuilder builder) throws IOException {
                NorthboundRequest nthbndRequest = builder.build();
                if (nthbndRequest == null) {
                    this.sendError(500, "Internal server error");
                    return false;
                }
                AccessMethodResponse cap = this.endpoint.execute(nthbndRequest);
                JSONObject result = new JSONResponseFormat().format((Object)cap.getJSON());
                if (result == null) {
                    this.sendError(500, "Internal server error");
                    return false;
                }
                JSONArray methods = result.optJSONArray("accessMethods");
                if (!JSONObject.NULL.equals(methods) && methods.length() > 0) {
                    for (int i = 0; i < methods.length(); ++i) {
                        JSONObject m = methods.getJSONObject(i);
                        if (!m.getString("name").equalsIgnoreCase(methodType)) continue;
                        ((CommandServiceMediator)mediator).getOutput().output(m, 0);
                    }
                }
                return true;
            }
        }.proceed();
    }

    @Descriptor(value="get the value of the default attribute resource of a sensiNact service")
    public void get(@Descriptor(value="the service provider ID") String serviceProviderID, @Descriptor(value="the service ID") String serviceID, @Descriptor(value="the resource ID") String resourceID) {
        ShellAccess.proceed(this.mediator, new JSONObject().put("uri", (Object)CommandServiceMediator.uri(serviceProviderID, serviceID, resourceID, "GET")));
    }

    @Descriptor(value="get the value of a specific attribute resource of a sensiNact service")
    public void get(@Descriptor(value="the service provider ID") String serviceProviderID, @Descriptor(value="the service ID") String serviceID, @Descriptor(value="the resource ID") String resourceID, @Descriptor(value="the attribute ID") String attributeID) {
        JSONArray params = new JSONArray();
        if (attributeID != null) {
            params.put((Object)new JSONObject().put("name", (Object)"attributeName").put("type", (Object)"string").put("value", (Object)attributeID));
        }
        ShellAccess.proceed(this.mediator, new JSONObject().put("uri", (Object)CommandServiceMediator.uri(serviceProviderID, serviceID, resourceID, "GET")).put("parameters", (Object)params));
    }

    @Descriptor(value="set a specific value to the default attribute resource of a sensiNact service")
    public void set(@Descriptor(value="the service provider ID") String serviceProviderID, @Descriptor(value="the service ID") String serviceID, @Descriptor(value="the resource ID") String resourceID, @Descriptor(value="the resource value") Object value) {
        this.set(serviceProviderID, serviceID, resourceID, "value", value);
    }

    @Descriptor(value="set a specific value to an attribute of a resource of a sensiNact service")
    public void set(@Descriptor(value="the service provider ID") String serviceProviderID, @Descriptor(value="the service ID") String serviceID, @Descriptor(value="the resource ID") String resourceID, @Descriptor(value="the attribute ID") String attributeID, @Descriptor(value="the resource value") Object value) {
        JSONArray params = new JSONArray();
        if (attributeID != null) {
            params.put((Object)new JSONObject().put("name", (Object)"attributeName").put("type", (Object)"string").put("value", (Object)attributeID));
        }
        params.put((Object)new JSONObject().put("name", (Object)"argument").put("type", (Object)"string").put("value", (Object)String.valueOf(value)));
        ShellAccess.proceed(this.mediator, new JSONObject().put("uri", (Object)CommandServiceMediator.uri(serviceProviderID, serviceID, resourceID, "SET")).put("parameters", (Object)params));
    }

    @Descriptor(value="execute a specific resource of a sensiNact service")
    public void act(@Descriptor(value="the service provider ID") String serviceProviderID, @Descriptor(value="the service ID") String serviceID, @Descriptor(value="the resource ID") String resourceID) {
        ShellAccess.proceed(this.mediator, new JSONObject().put("uri", (Object)CommandServiceMediator.uri(serviceProviderID, serviceID, resourceID, "ACT")));
    }

    @Descriptor(value="execute a specific resource of a sensiNact service")
    public void act(@Descriptor(value="the service provider ID") String serviceProviderID, @Descriptor(value="the service ID") String serviceID, @Descriptor(value="the resource ID") String resourceID, Object ... parameters) {
        int length;
        JSONArray params = new JSONArray();
        int n = length = parameters == null ? 0 : parameters.length;
        for (int index = 0; index < length; ++index) {
            params.put((Object)new JSONObject().put("name", (Object)("arg" + index)).put("type", (Object)"string").put("value", (Object)String.valueOf(parameters[index])));
        }
        ShellAccess.proceed(this.mediator, new JSONObject().put("uri", (Object)CommandServiceMediator.uri(serviceProviderID, serviceID, resourceID, "ACT")).put("parameters", (Object)params));
    }

    @Descriptor(value="subscribe to a specific attribute of a resource of a sensiNact service")
    public void subscribe(@Descriptor(value="the service provider ID") String serviceProviderID, @Descriptor(value="the service ID") String serviceID, @Descriptor(value="the resource ID") String resourceID, @Descriptor(value="the attribute ID") String attributeID, @Descriptor(value="the applying JSON formated conditions") String conditions) {
        JSONArray params = new JSONArray();
        if (attributeID != null) {
            params.put((Object)new JSONObject().put("name", (Object)"attributeName").put("type", (Object)"string").put("value", (Object)attributeID));
        }
        try {
            params.put((Object)new JSONObject().put("name", (Object)"conditions").put("type", (Object)"object").put("value", (Object)new JSONObject(conditions)));
        }
        catch (JSONException e) {
            LOG.error("Unable to parse the conditions", (Throwable)e);
        }
        ShellAccess.proceed(this.mediator, new JSONObject().put("uri", (Object)CommandServiceMediator.uri(serviceProviderID, serviceID, resourceID, "SUBSCRIBE")).put("parameters", (Object)params));
    }

    @Descriptor(value="cancel a specific subscription to a resource of a sensiNact service")
    public void unsubscribe(@Descriptor(value="the service provider ID") String serviceProviderID, @Descriptor(value="the service ID") String serviceID, @Descriptor(value="the resource ID") String resourceID, @Descriptor(value="the subscription ID") String subscriptionID) {
        JSONArray params = new JSONArray();
        params.put((Object)new JSONObject().put("name", (Object)"subscriptionId").put("type", (Object)"string").put("value", (Object)subscriptionID));
        ShellAccess.proceed(this.mediator, new JSONObject().put("uri", (Object)CommandServiceMediator.uri(serviceProviderID, serviceID, resourceID, "UNSUBSCRIBE")).put("parameters", (Object)params));
    }
}

