/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.commands.gogo.osgi;

import java.security.InvalidKeyException;
import org.eclipse.sensinact.gateway.commands.gogo.internal.shell.ShellOutput;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.Credentials;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundEndpoint;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.osgi.framework.BundleContext;

public class CommandServiceMediator
extends NorthboundMediator {
    private ShellOutput output;
    private NorthboundEndpoint endpoint = new NorthboundEndpoint((NorthboundMediator)this, null);
    private String userId = "anonymous";

    public static String uri(String serviceProvider, String service, String resource, boolean multi) {
        StringBuilder builder = new StringBuilder();
        builder.append("/sensinact");
        if (serviceProvider != null) {
            builder.append("/providers/");
            builder.append(serviceProvider);
            if (service != null) {
                builder.append("/services/");
                builder.append(service);
                if (resource != null) {
                    builder.append("/resources/");
                    builder.append(resource);
                } else if (multi) {
                    builder.append("/resources");
                }
            } else if (multi) {
                builder.append("/services");
            }
        } else if (multi) {
            builder.append("/providers");
        }
        return builder.toString();
    }

    public static String uri(String serviceProvider, String service, String resource, String method) {
        StringBuilder builder = new StringBuilder();
        builder.append(CommandServiceMediator.uri(serviceProvider, service, resource, false));
        builder.append("/");
        builder.append(method);
        return builder.toString();
    }

    CommandServiceMediator(BundleContext context) throws InvalidCredentialException {
        super(context);
        this.output = new ShellOutput();
    }

    public void switchUser() throws DataStoreException, InvalidKeyException, InvalidCredentialException {
        this.switchUser(null, null);
    }

    public void switchUser(String login, String password) throws DataStoreException, InvalidKeyException, InvalidCredentialException {
        if (login == null && password == null) {
            this.endpoint = new NorthboundEndpoint((NorthboundMediator)this, null);
            this.userId = "anonymous";
        } else {
            this.endpoint = new NorthboundEndpoint((NorthboundMediator)this, (Authentication)new Credentials(login, password));
            this.userId = login;
        }
    }

    public NorthboundEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ShellOutput getOutput() {
        return this.output;
    }

    public String getCurrentUser() {
        return this.userId;
    }
}

