/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.endpoint;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.common.primitive.PathElement;
import org.eclipse.sensinact.gateway.core.filtering.FilteringCollection;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.Argument;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.DefaultNorthboundRequestHandler;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;

public abstract class NorthboundRequest
implements PathElement,
Nameable {
    public static final String ROOT = "/sensinact";
    protected FilteringCollection filteringCollection;
    protected NorthboundMediator mediator;
    private String requestIdentifier;

    public static Map<NorthboundRequestWrapper.QueryKey, List<String>> processRequestQuery(String queryString) throws UnsupportedEncodingException {
        if (queryString == null) {
            return Collections.emptyMap();
        }
        HashMap<NorthboundRequestWrapper.QueryKey, List<String>> queryMap = new HashMap<NorthboundRequestWrapper.QueryKey, List<String>>();
        char[] characters = queryString.toCharArray();
        int pos = 0;
        int length = characters.length;
        boolean escape = false;
        String name = null;
        String value = null;
        StringBuilder element = new StringBuilder();
        block5: for (int index = 0; index < length; ++index) {
            char c = characters[index];
            if (escape) {
                escape = false;
                element.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = true;
                    continue block5;
                }
                case '=': {
                    if (name == null) {
                        name = element.toString();
                        element = new StringBuilder();
                        continue block5;
                    }
                    element.append(c);
                    continue block5;
                }
                case '&': {
                    value = element.toString();
                    NorthboundRequest.addQueryParameter(queryMap, pos++, name, value);
                    name = null;
                    value = null;
                    element = new StringBuilder();
                    continue block5;
                }
                default: {
                    element.append(c);
                }
            }
        }
        if (name == null && element.length() > 0) {
            name = element.toString();
            NorthboundRequest.addQueryParameter(queryMap, pos++, name, Boolean.TRUE.toString());
            return queryMap;
        }
        value = element.toString();
        NorthboundRequest.addQueryParameter(queryMap, pos++, name, value);
        return queryMap;
    }

    private static void addQueryParameter(Map<NorthboundRequestWrapper.QueryKey, List<String>> queryMap, int pos, String name, String value) throws UnsupportedEncodingException {
        name = name == null || name.length() == 0 ? DefaultNorthboundRequestHandler.RAW_QUERY_PARAMETER : URLDecoder.decode(name, "UTF-8");
        NorthboundRequestWrapper.QueryKey key = new NorthboundRequestWrapper.QueryKey();
        key.index = pos;
        key.name = name;
        List<String> values = queryMap.get(key);
        if (values == null) {
            values = new ArrayList<String>();
            queryMap.put(key, values);
        }
        values.add(URLDecoder.decode(value, "UTF-8"));
    }

    protected abstract String getMethod();

    public NorthboundRequest(String requestIdentifier, FilteringCollection filteringCollection) {
        this.requestIdentifier = requestIdentifier;
        this.filteringCollection = filteringCollection;
    }

    public String getPath() {
        return ROOT;
    }

    protected Argument[] getExecutionArguments() {
        Argument[] arguments = new Argument[]{new Argument(String.class, this.requestIdentifier)};
        return arguments;
    }
}

