/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.parser.proto.messages.PublishMessage;
import io.moquette.server.netty.NettyUtils;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.impl.BrokerInterceptor;
import io.moquette.spi.impl.DebugUtils;
import io.moquette.spi.impl.MessagesPublisher;
import io.moquette.spi.impl.ProtocolProcessor;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.SubscriptionsStore;
import io.moquette.spi.security.IAuthorizator;
import io.netty.channel.Channel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Qos0PublishHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Qos0PublishHandler.class);
    private final IAuthorizator m_authorizator;
    private final SubscriptionsStore subscriptions;
    private final IMessagesStore m_messagesStore;
    private final BrokerInterceptor m_interceptor;
    private final MessagesPublisher publisher;

    public Qos0PublishHandler(IAuthorizator authorizator, SubscriptionsStore subscriptions, IMessagesStore messagesStore, BrokerInterceptor interceptor, MessagesPublisher messagesPublisher) {
        this.m_authorizator = authorizator;
        this.subscriptions = subscriptions;
        this.m_messagesStore = messagesStore;
        this.m_interceptor = interceptor;
        this.publisher = messagesPublisher;
    }

    void receivedPublishQos0(Channel channel, PublishMessage msg) {
        String topic = msg.getTopicName();
        if (this.checkWriteOnTopic(topic, channel)) {
            return;
        }
        IMessagesStore.StoredMessage toStoreMsg = ProtocolProcessor.asStoredMessage(msg);
        String clientID = NettyUtils.clientID(channel);
        toStoreMsg.setClientID(clientID);
        LOG.debug("publish2Subscribers republishing to existing subscribers that matches the topic {}", (Object)topic);
        if (LOG.isTraceEnabled()) {
            LOG.trace("content <{}>", (Object)DebugUtils.payload2Str(toStoreMsg.getMessage()));
            LOG.trace("subscription tree {}", (Object)this.subscriptions.dumpTree());
        }
        List<Subscription> topicMatchingSubscriptions = this.subscriptions.matches(topic);
        this.publisher.publish2Subscribers(toStoreMsg, topicMatchingSubscriptions);
        if (msg.isRetainFlag()) {
            this.m_messagesStore.cleanRetained(topic);
        }
        String username = NettyUtils.userName(channel);
        this.m_interceptor.notifyTopicPublished(msg, clientID, username);
    }

    boolean checkWriteOnTopic(String topic, Channel channel) {
        String clientID = NettyUtils.clientID(channel);
        String username = NettyUtils.userName(channel);
        if (!this.m_authorizator.canWrite(topic, username, clientID)) {
            LOG.debug("topic {} doesn't have write credentials", (Object)topic);
            return true;
        }
        return false;
    }
}

