/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.RequirementBuilder;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.TypeConfig;
import org.eclipse.sensinact.gateway.generic.ExtResourceConfig;
import org.eclipse.sensinact.gateway.generic.ExtResourceImpl;
import org.eclipse.sensinact.gateway.generic.parser.AttributeDefinition;
import org.eclipse.sensinact.gateway.generic.parser.IdentifierDefinition;
import org.eclipse.sensinact.gateway.generic.parser.MethodDefinition;
import org.eclipse.sensinact.gateway.generic.parser.PolicyDefinition;
import org.eclipse.sensinact.gateway.generic.parser.RootXmlParsingContext;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttribute;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttributes;
import org.eclipse.sensinact.gateway.generic.parser.XmlEscaped;
import org.eclipse.sensinact.gateway.generic.parser.XmlModelParsingContext;
import org.xml.sax.Attributes;

@XmlAttributes(value={@XmlAttribute(attribute="name", field="name"), @XmlAttribute(attribute="target", field="target"), @XmlAttribute(attribute="profile", field="profile")})
@XmlEscaped(value={"attributes", "methods"})
public class ResourceInfoDefinition
extends XmlModelParsingContext {
    protected RootXmlParsingContext root;
    protected List<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
    protected List<MethodDefinition> methodDefinitions = new ArrayList<MethodDefinition>();
    protected IdentifierDefinition identifierDefinition;
    protected PolicyDefinition type;
    protected String name;
    protected String[] target;
    protected String[] profile;

    ResourceInfoDefinition(Mediator mediator, RootXmlParsingContext root, Attributes atts) {
        super(mediator, atts);
        this.root = root;
        this.setType(atts.getValue("xsi:type"));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        if (type.intern() == RootXmlParsingContext.RESOURCE_INFO_TYPE_ACTION.intern()) {
            this.type = this.root.getPolicy(TypeConfig.Type.ACTION.name());
        } else if (type.intern() == RootXmlParsingContext.RESOURCE_INFO_TYPE_PROPERTY.intern()) {
            this.type = this.root.getPolicy(TypeConfig.Type.PROPERTY.name());
        } else if (type.intern() == RootXmlParsingContext.RESOURCE_INFO_TYPE_SENSOR.intern()) {
            this.type = this.root.getPolicy(TypeConfig.Type.SENSOR.name());
        } else if (type.intern() == RootXmlParsingContext.RESOURCE_INFO_TYPE_VARIABLE.intern()) {
            this.type = this.root.getPolicy(TypeConfig.Type.STATE_VARIABLE.name());
        }
    }

    public void setTarget(String target) {
        String[] targets = target == null ? new String[]{} : target.split(",");
        this.target = new String[targets.length];
        if (this.target.length > 0) {
            for (int index = 0; index < this.target.length; ++index) {
                this.target[index] = "ANY_TARGET".equals(targets[index]) ? "#ANY_TARGET#" : targets[index].trim();
            }
        }
    }

    public String getTarget() {
        int length;
        StringBuilder builder = new StringBuilder();
        int n = length = this.target == null ? 0 : this.target.length;
        for (int index = 0; index < length; ++index) {
            if (index > 0) {
                builder.append(",");
            }
            builder.append(this.target[index].trim());
        }
        return builder.toString();
    }

    public String[] getTargets() {
        return this.target;
    }

    public boolean isTargeted(String serviceId) {
        for (int index = 0; index < this.target.length; ++index) {
            if (!this.target[index].equals("#ANY_TARGET#") && !this.target[index].equals(serviceId)) continue;
            return true;
        }
        return false;
    }

    public void setProfile(String profile) {
        String[] profiles = profile == null ? new String[]{} : profile.split(",");
        this.profile = new String[profiles.length];
        if (this.profile.length > 0) {
            for (int index = 0; index < this.profile.length; ++index) {
                this.profile[index] = "ANY_PROFILE".equals(profiles[index]) ? "#ANY_PROFILE#" : profiles[index].trim();
            }
        }
    }

    public String getProfile() {
        int length;
        StringBuilder builder = new StringBuilder();
        int n = length = this.profile == null ? 0 : this.profile.length;
        for (int index = 0; index < length; ++index) {
            if (index > 0) {
                builder.append(",");
            }
            builder.append(this.profile[index].trim());
        }
        return builder.toString();
    }

    public boolean isProfiled(String profileName) {
        for (int index = 0; index < this.profile.length; ++index) {
            if (!this.profile[index].equals("#ANY_PROFILE#") && !this.profile[index].equals(profileName)) continue;
            return true;
        }
        return false;
    }

    public void attributeStart(Attributes atts) {
        AttributeDefinition attributeDefinition = new AttributeDefinition(this.mediator, atts);
        String target = attributeDefinition.getTarget();
        if (target == null || "ANY_TARGET".equals(target)) {
            attributeDefinition.setTarget(this.getTarget());
        }
        this.attributeDefinitions.add(attributeDefinition);
        super.setNext(attributeDefinition);
    }

    public void identifierStart(Attributes atts) {
        IdentifierDefinition identifierDefinition;
        this.identifierDefinition = identifierDefinition = new IdentifierDefinition(this.mediator, atts);
        super.setNext(identifierDefinition);
    }

    public void methodStart(Attributes atts) {
        MethodDefinition methodDefinition = null;
        String name = atts.getValue("type");
        for (MethodDefinition def : this.methodDefinitions) {
            if (!def.getType().name().equals(name)) continue;
            methodDefinition = def;
            break;
        }
        if (methodDefinition == null) {
            methodDefinition = new MethodDefinition(this.mediator, atts);
            this.methodDefinitions.add(methodDefinition);
        }
        super.setNext(methodDefinition);
    }

    public void policyStart(Attributes atts) {
        PolicyDefinition policyDefinition;
        this.type = policyDefinition = new PolicyDefinition(this.mediator, atts);
        super.setNext(policyDefinition);
    }

    public ResourceConfig asResourceConfig() {
        Class<? extends Resource> implementationInterface;
        String[] stringArray;
        String[] stringArray2;
        ExtResourceConfig resourceConfig = new ExtResourceConfig(this.attributeDefinitions, this.methodDefinitions);
        String target = this.getTarget();
        if (target == null || target.length() == 0 || "ANY_TARGET".equals(target)) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "#ANY_TARGET#";
        } else {
            stringArray2 = this.target;
        }
        String[] targets = stringArray2;
        String profile = this.getProfile();
        if (profile == null || profile.length() == 0 || "ANY_PROFILE".equals(profile)) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "#ANY_PROFILE#";
        } else {
            stringArray = this.profile;
        }
        String[] profiles = stringArray;
        RequirementBuilder requirementBuilder = new RequirementBuilder(AttributeBuilder.Requirement.VALUE, "name");
        requirementBuilder.put("#ANY_TARGET#", (Object)this.name);
        resourceConfig.addRequirementBuilder(requirementBuilder);
        resourceConfig.setTarget(target);
        resourceConfig.setProfile(profile);
        resourceConfig.setIdentifier(this.identifierDefinition.getIdentifier());
        PolicyDefinition registered = this.root.getPolicy(this.type.getPolicy().name());
        this.root.registerProfile(profiles, "#ANY_TARGET#".equals(target) ? null : targets);
        resourceConfig.setUpdatePolicy(this.type.getUpdatePolicy());
        TypeConfig resourceTypeConfig = new TypeConfig(this.type.getPolicy());
        Class<? extends ExtResourceImpl> implementationClass = this.type.getPolicyImplementationClass();
        if (implementationClass == null) {
            implementationClass = registered.getPolicyImplementationClass();
        }
        if ((implementationInterface = this.type.getPolicyImplementationInterface()) == null) {
            implementationInterface = registered.getPolicyImplementationInterface();
        }
        resourceTypeConfig.setImplementationClass(implementationClass);
        resourceTypeConfig.setResourceImplementedInterface(implementationInterface);
        resourceConfig.setTypeConfig(resourceTypeConfig);
        requirementBuilder = new RequirementBuilder(AttributeBuilder.Requirement.VALUE, "type");
        requirementBuilder.put("#ANY_TARGET#", (Object)resourceConfig.getTypeConfig().getResourceType());
        resourceConfig.addRequirementBuilder(requirementBuilder);
        return resourceConfig;
    }
}

