/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.method.Shortcut;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.eclipse.sensinact.gateway.generic.parser.ParameterDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ReferenceDefinition;

public class SignatureDefinition
implements Comparable<SignatureDefinition> {
    protected List<ReferenceDefinition> references;
    private List<ParameterDefinition> parameters;
    private final AccessMethod.Type type;

    public SignatureDefinition(AccessMethod.Type type) {
        this.type = type;
        this.parameters = new ArrayList<ParameterDefinition>();
        this.references = new ArrayList<ReferenceDefinition>();
    }

    public void addReferenceDefinition(ReferenceDefinition referenceDefinition) {
        this.references.add(referenceDefinition);
    }

    public List<ReferenceDefinition> getReferenceDefinitions() {
        return Collections.unmodifiableList(this.references);
    }

    public void addParameter(ParameterDefinition parameter) {
        if (parameter != null) {
            this.parameters.add(parameter);
        }
    }

    public Signature getSignature(Mediator mediator, ResourceImpl resource, ServiceImpl service) throws InvalidValueException {
        HashMap<Integer, Parameter> fixedParameters = new HashMap<Integer, Parameter>();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Object signature = null;
        Iterator<ParameterDefinition> parameterIterator = this.parameters.iterator();
        int position = 0;
        while (parameterIterator.hasNext()) {
            ParameterDefinition parameterDefinition = parameterIterator.next();
            Parameter parameter = parameterDefinition.getParameter(resource, service);
            if (Modifiable.FIXED.equals((Object)parameter.getModifiable())) {
                fixedParameters.put(position, parameter);
            } else {
                parameters.add(parameter);
            }
            ++position;
        }
        Parameter[] parametersArray = parameters.toArray(new Parameter[parameters.size()]);
        signature = fixedParameters.isEmpty() ? new Signature(mediator, this.type.name(), parametersArray) : new Shortcut(mediator, this.type.name(), parametersArray, fixedParameters);
        return signature;
    }

    public int size() {
        return this.parameters.size();
    }

    public int fixedSize() {
        Iterator<ParameterDefinition> parameterIterator = this.parameters.iterator();
        int count = 0;
        while (parameterIterator.hasNext()) {
            count += parameterIterator.next().isModifiable() ? 0 : 1;
        }
        return count;
    }

    @Override
    public int compareTo(SignatureDefinition definition) {
        int compare = new Integer(this.size()).compareTo(definition.size());
        if (compare != 0) {
            return compare;
        }
        return new Integer(this.fixedSize()).compareTo(definition.fixedSize());
    }

    public List<ParameterDefinition> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }
}

