/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.filter.attributes;

import java.util.Arrays;
import org.eclipse.sensinact.gateway.core.filtering.Filtering;
import org.eclipse.sensinact.gateway.core.filtering.FilteringType;
import org.osgi.service.component.annotations.Component;

@FilteringType(value={"attrs"})
@Component(immediate=true, service={Filtering.class})
public class AttributesFiltering
implements Filtering {
    public static final String ATTRS = "attrs";

    public boolean handle(String type) {
        return ATTRS.equals(type);
    }

    public String apply(String definition, Object result) {
        return String.valueOf(result);
    }

    public String getLDAPComponent(String definition) {
        String definitionContent = definition;
        if (definition.startsWith("{") || definition.startsWith("[")) {
            definitionContent = definition.substring(1, definition.length() - 1);
        }
        String[] defs = definitionContent.split(",");
        StringBuilder builder = Arrays.asList(defs).stream().collect(() -> new StringBuilder(), (sb, s) -> {
            if (sb.length() == 0 && defs.length > 1) {
                sb.append("(&");
            }
            sb.append("(admin.");
            sb.append((String)s);
            sb.append(".value=*)");
        }, (sb1, sb2) -> sb1.append(sb2.toString()));
        if (defs.length > 1) {
            builder.append(")");
        }
        return builder.toString();
    }
}

