/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao;

import java.util.HashMap;
import java.util.List;
import org.eclipse.sensinact.gateway.core.security.dao.AbstractMutableSnaDAO;
import org.eclipse.sensinact.gateway.core.security.dao.AgentDAO;
import org.eclipse.sensinact.gateway.core.security.dao.ApplicationDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.dao.ObjectDAO;
import org.eclipse.sensinact.gateway.core.security.dao.UserDAO;
import org.eclipse.sensinact.gateway.core.security.entity.AgentEntity;
import org.eclipse.sensinact.gateway.core.security.entity.ApplicationEntity;
import org.eclipse.sensinact.gateway.core.security.entity.AuthenticatedEntity;
import org.eclipse.sensinact.gateway.core.security.entity.ObjectEntity;
import org.eclipse.sensinact.gateway.core.security.entity.UserEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;

public class AuthenticatedDAO
extends AbstractMutableSnaDAO<AuthenticatedEntity> {
    private ObjectDAO objectDAO = null;
    private UserDAO userDAO = null;
    private AgentDAO agentDAO = null;
    private ApplicationDAO applicationDAO = null;

    public AuthenticatedDAO(DataStoreService dataStoreService) throws DAOException {
        super(AuthenticatedEntity.class, dataStoreService);
        this.objectDAO = new ObjectDAO(dataStoreService);
        this.userDAO = new UserDAO(dataStoreService);
        this.agentDAO = new AgentDAO(dataStoreService);
        this.applicationDAO = new ApplicationDAO(dataStoreService);
    }

    public AuthenticatedEntity findFromUser(String path, long uid) throws DAOException, DataStoreException {
        AuthenticatedEntity entity = null;
        UserEntity user = this.userDAO.find(uid);
        if (user != null) {
            entity = this.find(path, user.getPublicKey());
        }
        return entity;
    }

    public AuthenticatedEntity findFromAgent(String path, long aid) throws DAOException, DataStoreException {
        AuthenticatedEntity entity = null;
        AgentEntity agent = this.agentDAO.find(aid);
        if (agent != null) {
            entity = this.find(path, agent.getPublicKey());
        }
        return entity;
    }

    public AuthenticatedEntity findFromApplication(String path, long appid) throws DAOException, DataStoreException {
        AuthenticatedEntity entity = null;
        ApplicationEntity application = this.applicationDAO.find(appid);
        if (application != null) {
            entity = this.find(path, application.getPublicKey());
        }
        return entity;
    }

    public AuthenticatedEntity find(String path, final String publicKey) throws DAOException, DataStoreException {
        List<ObjectEntity> objectEntities = this.objectDAO.find(path);
        if (objectEntities.size() <= 0) {
            throw new DAOException(String.format("Unknown element at '%s'", path));
        }
        final ObjectEntity objectEntity = objectEntities.get(0);
        List authenticatedEntities = super.select(new HashMap<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("OID", objectEntity.getIdentifier());
                this.put("PUBLIC_KEY", publicKey);
            }
        });
        if (authenticatedEntities.size() != 1) {
            return null;
        }
        return (AuthenticatedEntity)authenticatedEntities.get(0);
    }
}

