/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.entity;

import java.security.InvalidKeyException;
import org.eclipse.sensinact.gateway.core.security.User;
import org.eclipse.sensinact.gateway.core.security.entity.SnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Column;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.PrimaryKey;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Table;
import org.eclipse.sensinact.gateway.util.CryptoUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Table(value="SNAUSER")
@PrimaryKey(value={"SUID"})
public class UserEntity
extends SnaEntity
implements User {
    private static final Logger LOG = LoggerFactory.getLogger(UserEntity.class);
    @Column(value="SUID")
    private long identifier;
    @Column(value="SULOGIN")
    private String login;
    @Column(value="SUPASSWORD")
    private String password;
    @Column(value="SUACCOUNT")
    private String account;
    @Column(value="SUACCOUNTTYPE")
    private String accounttype;
    @Column(value="SUPUBLIC_KEY")
    private String publicKey;

    public UserEntity() {
    }

    public UserEntity(JSONObject row) {
        super(row);
    }

    public UserEntity(String login, String password, String account) {
        this(login, password, account, null, null);
    }

    public UserEntity(String login, String password, String account, String accounttype) {
        this(login, password, account, accounttype, null);
    }

    public UserEntity(String login, String password, String account, String accounttype, String publicKey) {
        this();
        this.setLogin(login);
        this.setPassword(password);
        this.setAccount(account);
        this.setAccounttype(accounttype);
        this.setPublicKey(publicKey);
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(long identifier) {
        this.identifier = identifier;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccounttype() {
        if (this.accounttype == null) {
            return "MAIL";
        }
        return this.accounttype;
    }

    public void setAccounttype(String accounttype) {
        this.accounttype = accounttype;
    }

    public String getPublicKey() {
        if (this.publicKey == null) {
            String publicKeyStr = this.login + ":" + this.account + System.currentTimeMillis();
            try {
                this.publicKey = CryptoUtils.cryptWithMD5((String)publicKeyStr);
            }
            catch (InvalidKeyException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getAccountType() {
        return this.getAccounttype();
    }

    public boolean isAnonymous() {
        return this.getPublicKey().startsWith("anonymous");
    }
}

