/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.http;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.SessionToken;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundAccess;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundEndpoint;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestBuilder;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.RestAccessConstants;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.http.HttpRestAccessRequest;

public class HttpRestAccess
extends NorthboundAccess<HttpRestAccessRequest> {
    private HttpServletResponseWrapper response;
    private NorthboundEndpoint endpoint;

    public HttpRestAccess(HttpRestAccessRequest request, HttpServletResponseWrapper response) throws IOException, InvalidCredentialException {
        super((NorthboundRequestWrapper)request);
        this.response = response;
        Authentication<?> authentication = request.getAuthentication();
        if (authentication == null) {
            this.endpoint = request.getMediator().getNorthboundEndpoints().getEndpoint();
            response.setHeader("X-Auth-Token", this.endpoint.getSessionToken());
        } else if (SessionToken.class.isAssignableFrom(authentication.getClass())) {
            this.endpoint = request.getMediator().getNorthboundEndpoints().getEndpoint((SessionToken)authentication);
            if (this.endpoint == null) {
                throw new InvalidCredentialException("Unrecognised session token");
            }
        } else {
            throw new InvalidCredentialException("Authentication token was expected");
        }
    }

    protected boolean respond(NorthboundMediator mediator, NorthboundRequestBuilder builder) throws IOException {
        byte[] resultBytes;
        String snaMethod;
        String httpMethod = ((HttpRestAccessRequest)this.request).getMethod();
        switch (snaMethod = builder.getMethod()) {
            case "DESCRIBE": 
            case "GET": {
                if ("GET".equals(httpMethod)) break;
                this.sendError(400, "Invalid HTTP method");
                return false;
            }
            case "ACT": 
            case "UNSUBSCRIBE": 
            case "SET": 
            case "SUBSCRIBE": {
                if ("POST".equals(httpMethod)) break;
                this.sendError(400, "Invalid HTTP method");
                return false;
            }
        }
        NorthboundRequest nthbndRequest = builder.build();
        if (nthbndRequest == null) {
            this.sendError(500, "Internal server error");
            return false;
        }
        AccessMethodResponse cap = this.endpoint.execute(nthbndRequest);
        if (cap == null) {
            this.sendError(500, "Internal server error");
            return false;
        }
        String result = null;
        List<String> rawList = null;
        Map<NorthboundRequestWrapper.QueryKey, List<String>> queryMap = ((HttpRestAccessRequest)this.request).getQueryMap();
        for (NorthboundRequestWrapper.QueryKey queryKey : queryMap.keySet()) {
            if (!"rawDescribe".equals(queryKey.name)) continue;
            rawList = queryMap.get(queryKey);
            break;
        }
        result = rawList != null && (rawList.contains("true") || rawList.contains("True") || rawList.contains("yes") || rawList.contains("Yes")) && DescribeResponse.class.isAssignableFrom(cap.getClass()) ? ((DescribeResponse)cap).getJSON(true) : cap.getJSON();
        String acceptEncoding = ((HttpRestAccessRequest)this.request).getHeader("Accept-Encoding");
        if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
            resultBytes = NorthboundAccess.compress((String)result);
            this.response.setHeader("Content-Encoding", "gzip");
        } else {
            resultBytes = result.getBytes("UTF-8");
        }
        int length = -1;
        length = resultBytes == null ? 0 : resultBytes.length;
        if (length > 0) {
            this.response.setContentType(RestAccessConstants.JSON_CONTENT_TYPE);
            this.response.setContentLength(resultBytes.length);
            this.response.setBufferSize(resultBytes.length);
            ServletOutputStream output = this.response.getOutputStream();
            output.write(resultBytes);
        }
        this.response.setStatus(cap.getStatusCode());
        return true;
    }

    protected void sendError(int statusCode, String message) throws IOException {
        this.response.sendError(statusCode, message);
    }
}

