/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import org.apache.aries.rsa.provider.fastbin.BaseActivator;
import org.apache.aries.rsa.provider.fastbin.FastBinProvider;
import org.apache.aries.rsa.provider.fastbin.io.ClientInvoker;
import org.apache.aries.rsa.provider.fastbin.io.ServerInvoker;
import org.apache.aries.rsa.provider.fastbin.util.UuidGenerator;
import org.apache.aries.rsa.spi.DistributionProvider;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends BaseActivator
implements ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    static Activator INSTANCE;
    FastBinProvider provider;
    ClientInvoker client;
    ServerInvoker server;

    @Override
    protected void doOpen() throws Exception {
        this.manage("org.apache.aries.rsa.provider.fastbin");
    }

    @Override
    protected void doStart() throws Exception {
        INSTANCE = this;
        String uri = this.getString("uri", "tcp://0.0.0.0:2543");
        LOG.info("Binding Fastbin Server to {}", (Object)uri);
        String exportedAddress = this.getString("exportedAddress", null);
        if (exportedAddress == null) {
            exportedAddress = UuidGenerator.getHostName();
        }
        long timeout = this.getLong("timeout", TimeUnit.MINUTES.toMillis(5L));
        this.provider = new FastBinProvider(uri, exportedAddress, timeout);
        this.client = this.provider.getClient();
        this.server = this.provider.getServer();
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("remote.intents.supported", new String[0]);
        ((Dictionary)props).put("remote.configs.supported", this.provider.getSupportedTypes());
        this.register(DistributionProvider.class, this.provider, props);
    }

    @Override
    protected void doStop() {
        super.doStop();
        if (this.provider != null) {
            try {
                this.provider.close();
            }
            finally {
                this.provider = null;
            }
        }
    }

    public ClientInvoker getClient() {
        return this.client;
    }

    public ServerInvoker getServer() {
        return this.server;
    }

    public static Activator getInstance() {
        return INSTANCE;
    }
}

