/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.execution;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.common.execution.Execution;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger LOG = Logger.getLogger(DefaultErrorHandler.class.getName());
    private JSONArray errors;
    private volatile int exceptions = 0;
    private Execution alternative;
    private Object[] alternativeParameters;
    private Object alternativeResult;
    private final int policy;

    public DefaultErrorHandler() {
        this(0x100010);
    }

    public DefaultErrorHandler(int policy) {
        this.policy = policy;
    }

    @Override
    public int handle(Exception exception) {
        if (exception == null) {
            return 4096;
        }
        ++this.exceptions;
        JSONObject exceptionObject = new JSONObject();
        exceptionObject.put("message", (Object)exception.getMessage());
        StringBuilder buffer = new StringBuilder();
        if (exception != null) {
            StackTraceElement[] trace = exception.getStackTrace();
            int length = trace.length;
            for (int index = 0; index < length; ++index) {
                buffer.append(trace[index].toString());
                buffer.append("\n");
            }
        }
        exceptionObject.put("trace", (Object)buffer.toString());
        if (this.errors == null) {
            this.errors = new JSONArray();
        }
        this.errors.put((Object)exceptionObject);
        int policy = this.getPolicy();
        if (ErrorHandler.Policy.contains(policy, 0x100000)) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (ErrorHandler.Policy.contains(policy, 65536) && this.alternative != null) {
            Object[] arguments = this.alternativeParameters;
            this.alternative.prepare(arguments);
            this.alternative.process(arguments);
            this.alternative.conclude();
            this.alternativeResult = this.alternative.getResult();
        }
        if (ErrorHandler.Policy.contains(policy, 4096)) {
            return 4096;
        }
        if (ErrorHandler.Policy.contains(policy, 256)) {
            return 256;
        }
        if (ErrorHandler.Policy.contains(policy, 1)) {
            return 1;
        }
        return 16;
    }

    @Override
    public int getPolicy() {
        return this.policy;
    }

    @Override
    public JSONArray getStackTrace() {
        return this.errors;
    }

    @Override
    public void setAlternative(Execution alternative) {
        this.alternative = alternative;
    }

    @Override
    public void setAlternativeParameters(Object[] parameters) {
        this.alternativeParameters = parameters;
    }

    @Override
    public int getExceptions() {
        return this.exceptions;
    }

    @Override
    public Object getAlternativeResult() {
        return this.alternativeResult;
    }
}

