/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.execution.DefaultErrorHandler;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.Description;
import org.eclipse.sensinact.gateway.common.primitive.ElementsProxy;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.common.primitive.PrimitiveDescription;
import org.eclipse.sensinact.gateway.common.primitive.Typable;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.AttributeDescription;
import org.eclipse.sensinact.gateway.core.InvalidAttributeException;
import org.eclipse.sensinact.gateway.core.Metadata;
import org.eclipse.sensinact.gateway.core.MetadataDescription;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelElement;
import org.eclipse.sensinact.gateway.core.ModelElementProxy;
import org.eclipse.sensinact.gateway.core.ModelElementProxyBuildException;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceProcessableContainer;
import org.eclipse.sensinact.gateway.core.ResourceProcessableData;
import org.eclipse.sensinact.gateway.core.ResourceProxy;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.message.AbstractMidCallback;
import org.eclipse.sensinact.gateway.core.message.AbstractSnaMessage;
import org.eclipse.sensinact.gateway.core.message.BufferMidCallback;
import org.eclipse.sensinact.gateway.core.message.MidCallback;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.ScheduledBufferMidCallback;
import org.eclipse.sensinact.gateway.core.message.ScheduledMidCallback;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaNotificationMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessage;
import org.eclipse.sensinact.gateway.core.message.SubscriptionFilter;
import org.eclipse.sensinact.gateway.core.message.UnaryMidCallback;
import org.eclipse.sensinact.gateway.core.method.AbstractAccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.core.security.ImmutableAccessTree;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceImpl
extends ModelElement<ModelInstance<?>, ResourceProxy, ResourceProcessableContainer<?>, Attribute, AttributeDescription>
implements Typable<Resource.Type> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceImpl.class);
    protected final Map<AccessMethod.Type, AccessMethod<?, ?>> methods = new HashMap();
    protected final List<String> links = new ArrayList<String>();
    protected final Class<? extends Resource> resourceType;
    protected String defaultAttribute;
    protected Resource.UpdatePolicy updatePolicy;

    protected ResourceImpl(ModelInstance<?> modelInstance, ResourceConfig resourceConfig, ServiceImpl service) {
        super(modelInstance, service, UriUtils.getUri((String[])new String[]{service.getPath(), resourceConfig.buildName(service.getName())}));
        this.resourceType = resourceConfig.getTypeConfig().getResourceImplementedInterface();
        this.setUpdatePolicy(resourceConfig.getUpdatePolicy());
        this.buildAttributes(resourceConfig);
    }

    @Override
    public void process(ResourceProcessableContainer data) {
        if (data == null) {
            return;
        }
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            ResourceProcessableData resourceProcessableData = (ResourceProcessableData)iterator.next();
            String attributeId = resourceProcessableData.getAttributeId();
            String metadataName = resourceProcessableData.getMetadataId();
            try {
                this.update(attributeId, metadataName, resourceProcessableData.getData(), resourceProcessableData.getTimestamp());
            }
            catch (InvalidValueException e) {
                LOG.error("'%s' resource cannot be updated", (Object)this.getPath(), (Object)e);
            }
        }
    }

    protected void update(String attributeName, String metadataName, Object value, long timestamp) throws InvalidValueException {
        String name;
        if (value == null) {
            LOG.warn("Null object value : unable to update resource '" + this.getPath() + "'");
            return;
        }
        String string = name = attributeName == null ? this.getDefault() : attributeName;
        if (name == null) {
            LOG.warn("Null attribute name : unable to update resource '" + this.getPath() + "'");
            return;
        }
        Attribute attribute = this.getAttribute(name);
        byte buildPolicy = ((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceBuildPolicy();
        if (attribute == null && SensiNactResourceModelConfiguration.BuildPolicy.isBuildPolicy(buildPolicy, SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED) && !this.addAttribute(attribute = new Attribute(((ModelInstance)this.modelInstance).mediator(), this, name, String.class, null, Modifiable.UPDATABLE, false))) {
            LOG.warn("Error when creating attribute '%s': unable to update resource '%s", (Object)name, (Object)this.getPath());
            return;
        }
        if (attribute == null) {
            LOG.warn("Null attribute '" + name + "': unable to update resource '" + this.getPath() + "'");
            return;
        }
        if (metadataName != null) {
            Metadata metadata = attribute.get(metadataName);
            if (metadata == null && SensiNactResourceModelConfiguration.BuildPolicy.isBuildPolicy(buildPolicy, SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED)) {
                metadata = new Metadata(((ModelInstance)this.modelInstance).mediator(), metadataName, String.class, null, Modifiable.UPDATABLE);
                attribute.addMetadata(metadata);
            }
            if (metadata == null) {
                LOG.warn("Null metadata " + metadataName + ": unable to update resource '" + this.getPath() + "'");
                return;
            }
            attribute.setMetadataValue(metadataName, value);
        } else {
            long valueTimestamp = timestamp > 0L ? timestamp : System.currentTimeMillis();
            attribute.setValue(value, valueTimestamp);
        }
    }

    public void buildAttributes(ResourceConfig resourceConfig) {
        try {
            String parentPath = UriUtils.getParentUri((String)super.getPath());
            String parentName = UriUtils.getLeaf((String)parentPath);
            String defaultAttributeName = (String)resourceConfig.getTypeConfig().getConstantValue("ATTRIBUTE_DEFAULT", false);
            this.setDefault(defaultAttributeName);
            List<AttributeBuilder> builders = resourceConfig.getAttributeBuilders(parentName);
            int length = builders == null ? 0 : builders.size();
            for (int index = 0; index < length; ++index) {
                Attribute attribute = null;
                try {
                    attribute = builders.get(index).getAttribute(((ModelInstance)this.modelInstance).mediator(), this, resourceConfig.getTypeConfig());
                }
                catch (InvalidAttributeException e) {
                    LOG.error(e.getMessage());
                }
                if (attribute == null) continue;
                if (attribute.getName().equals(defaultAttributeName)) {
                    try {
                        Metadata metadata = new Metadata(((ModelInstance)this.modelInstance).mediator(), "nickname", String.class, this.getName(), Modifiable.FIXED);
                        attribute.addMetadata(metadata);
                    }
                    catch (InvalidValueException e) {
                        LOG.error(e.getMessage());
                    }
                }
                this.addAttribute(attribute);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Executable<Void, Object> getResourceValueExtractor(String attributeName) {
        String defaultAttributeName = attributeName == null ? this.getDefault() : attributeName;
        final Attribute attribute = this.getAttribute(defaultAttributeName);
        return new Executable<Void, Object>(){

            public Object execute(Void parameter) throws Exception {
                if (attribute != null) {
                    return attribute.getValue();
                }
                return null;
            }
        };
    }

    public AttributeDescription set(String attributeName, Object value) throws InvalidValueException {
        AttributeDescription description = null;
        if (attributeName == null) {
            return description;
        }
        Attribute attribute = this.getAttribute(attributeName);
        if (attribute != null) {
            if (!Modifiable.MODIFIABLE.equals((Object)attribute.getModifiable())) {
                throw new InvalidValueException(attributeName + " attribute is not modifiable");
            }
            if (attribute.getLocked()) {
                throw new InvalidValueException(attributeName + " attribute has been locked by an action trigger");
            }
            attribute.setValue(value);
            description = (AttributeDescription)attribute.getDescription();
        }
        return description;
    }

    public AttributeDescription set(Object value) throws InvalidValueException {
        return this.set(this.getDefault(), value);
    }

    public boolean addAttribute(Attribute attribute) {
        return super.addElement(attribute);
    }

    public boolean removeAttribute(String attributeName) {
        if (attributeName == null || "name".intern() == attributeName.intern() || "type".intern() == attributeName.intern() || "value".intern() == attributeName.intern()) {
            return false;
        }
        return super.removeElement(attributeName) != null;
    }

    public Attribute getAttribute(String name) {
        return (Attribute)super.element(name);
    }

    public AttributeDescription getDescription(String name) {
        AttributeDescription description = null;
        Attribute attribute = this.getAttribute(name);
        if (attribute != null) {
            description = (AttributeDescription)attribute.getDescription();
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttributeDescription> getAllDescriptions() {
        ArrayList<AttributeDescription> descriptions = new ArrayList<AttributeDescription>();
        List list = this.elements;
        synchronized (list) {
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                descriptions.add((AttributeDescription)((Attribute)((Object)iterator.next())).getDescription());
            }
        }
        return descriptions;
    }

    public String getDefault() {
        return this.defaultAttribute;
    }

    void setDefault(String defaultAttribute) {
        this.defaultAttribute = defaultAttribute;
    }

    public boolean isHidden() {
        if (this.defaultAttribute == null) {
            return false;
        }
        try {
            Attribute attribute = this.getAttribute(this.defaultAttribute);
            return attribute.isHidden();
        }
        catch (Exception e) {
            return false;
        }
    }

    public <S extends Resource> Class<S> getResourceType() {
        return this.resourceType;
    }

    public String getName() {
        return (String)this.getAttribute("name").getValue();
    }

    public Resource.Type getType() {
        return (Resource.Type)((Object)this.getAttribute("type").getValue());
    }

    protected String listen(String attributeName, Recipient recipient, Set<Constraint> conditions, int policy, MidCallback.Type type, long lifetime, int buffer, int delay) {
        StringBuilder builder = new StringBuilder();
        builder = new StringBuilder();
        builder.append(this.getPath());
        builder.append("/");
        builder.append(attributeName);
        String filter = builder.toString();
        MidCallback.Type callbackType = type == null ? MidCallback.Type.UNARY : type;
        long timeout = lifetime <= 10000L ? -1L : System.currentTimeMillis() + lifetime;
        int schedulerDelay = delay < 1000 ? 1000 : delay;
        int bufferSize = buffer < 10 ? 10 : buffer;
        AbstractMidCallback callback = null;
        switch (callbackType) {
            case BUFFERERIZED_AND_SCHEDULED: {
                callback = new ScheduledBufferMidCallback(((ModelInstance)this.modelInstance).mediator(), (ErrorHandler)new DefaultErrorHandler(policy), recipient, timeout, schedulerDelay, bufferSize);
                break;
            }
            case BUFFERIZED: {
                callback = new BufferMidCallback(((ModelInstance)this.modelInstance).mediator(), (ErrorHandler)new DefaultErrorHandler(policy), recipient, timeout, bufferSize);
                break;
            }
            case SCHEDULED: {
                callback = new ScheduledMidCallback(((ModelInstance)this.modelInstance).mediator(), (ErrorHandler)new DefaultErrorHandler(policy), recipient, timeout, schedulerDelay);
                break;
            }
            case UNARY: {
                callback = new UnaryMidCallback(((ModelInstance)this.modelInstance).mediator(), (ErrorHandler)new DefaultErrorHandler(policy), recipient, timeout);
                break;
            }
        }
        if (callback != null) {
            ((ModelInstance)this.modelInstance).registerCallback(new SubscriptionFilter(((ModelInstance)this.modelInstance).mediator(), filter, conditions), callback);
            return callback.getName();
        }
        return null;
    }

    protected void unlisten(String callbackId) {
        ((ModelInstance)this.modelInstance).unregisterCallback(callbackId);
    }

    public AccessMethod<?, ?> getAccessMethod(AccessMethod.Type method) {
        return this.methods.get(method);
    }

    public AccessMethod<?, ?> registerExecutor(AccessMethod.Type type, Class<?>[] parameterTypes, String[] parameterNames, AccessMethodExecutor executor, AccessMethodExecutor.ExecutionPolicy policy) throws InvalidValueException {
        AccessMethod<?, ?> method = this.getAccessMethod(type);
        if (method != null) {
            ((AbstractAccessMethod)method).addSignature(parameterTypes, parameterNames, executor, policy);
        }
        return method;
    }

    public AccessMethod<?, ?> registerExecutor(Signature signature, AccessMethodExecutor executor, AccessMethodExecutor.ExecutionPolicy policy) {
        AccessMethod<?, ?> method = this.getAccessMethod(AccessMethod.Type.valueOf(signature.getName()));
        if (method != null) {
            ((AbstractAccessMethod)method).addSignature(signature, executor, policy);
        }
        return method;
    }

    public Enumeration<Attribute> attributes() {
        return super.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updated(Attribute attribute, Object value, boolean hasChanged) {
        if (!this.started.get() || attribute.isHidden()) {
            return;
        }
        String[] links = new String[this.links.size() + 1];
        List<String> list = this.links;
        synchronized (list) {
            this.links.toArray(links);
        }
        links[this.links.size()] = this.getPath();
        int length = links.length;
        JSONObject attributeDescription = new JSONObject(attribute.getDescription().getJSON());
        for (int index = 0; index < length; ++index) {
            StringBuilder buffer = new StringBuilder();
            buffer = new StringBuilder();
            buffer.append(links[index]);
            buffer.append("/");
            buffer.append(attribute.getName());
            String path = buffer.toString();
            SnaUpdateMessage message = (SnaUpdateMessage)SnaNotificationMessageImpl.Builder.notification(((ModelInstance)this.modelInstance).mediator(), SnaUpdateMessage.Update.ATTRIBUTE_VALUE_UPDATED, path);
            message.setNotification(attributeDescription);
            ((AbstractSnaMessage)((Object)message)).put("hasChanged", hasChanged, true);
            ((ModelInstance)this.modelInstance).postMessage(message);
        }
    }

    protected void updated(Attribute attribute, MetadataDescription metadata) {
        if (!this.started.get() || attribute == null || metadata == null) {
            return;
        }
        SnaUpdateMessage message = (SnaUpdateMessage)SnaNotificationMessageImpl.Builder.notification(((ModelInstance)this.modelInstance).mediator(), SnaUpdateMessage.Update.METADATA_VALUE_UPDATED, UriUtils.getUri((String[])new String[]{this.getPath(), attribute.getName(), metadata.getName()}));
        message.setNotification(metadata.getJSONObjectDescription());
        ((ModelInstance)this.modelInstance).postMessage(message);
    }

    protected void registerLink(String path) {
        this.links.add(path);
    }

    @Override
    public void start() {
        if (!((ModelInstance)super.getModelInstance()).isRegistered() || this.isHidden()) {
            return;
        }
        if (this.started.get()) {
            LOG.debug("%s already started", (Object)this.getName());
            return;
        }
        this.started.set(true);
        LOG.debug("'%s' resource registered", (Object)this.getName());
        String path = this.getPath();
        SnaLifecycleMessage notification = (SnaLifecycleMessage)SnaNotificationMessageImpl.Builder.notification(((ModelInstance)this.modelInstance).mediator(), SnaLifecycleMessage.Lifecycle.RESOURCE_APPEARING, path);
        JSONObject notificationObject = new JSONObject();
        notificationObject.put("lifecycle", (Object)SnaLifecycleMessage.Lifecycle.RESOURCE_APPEARING.name());
        notificationObject.put("type", (Object)this.getType());
        notification.setNotification(notificationObject);
        for (Attribute attribute : this.elements) {
            if (this.defaultAttribute != null && attribute.getName().equals(this.defaultAttribute)) {
                JSONObject jsonAttribute = new JSONObject(attribute.getDescription().getJSON());
                for (MetadataDescription metadataDescription : attribute.getAllDescriptions()) {
                    String metadataName = metadataDescription.getName().intern();
                    if (!Modifiable.FIXED.equals((Object)metadataDescription.getModifiable()) || "locked".intern() == metadataName || "hidden".intern() == metadataName || "nickname".intern() == metadataName) continue;
                    jsonAttribute.put(metadataDescription.getName(), PrimitiveDescription.toJson((Class)metadataDescription.getType(), (Object)metadataDescription.getValue()));
                }
                ((SnaLifecycleMessageImpl)notification).put("initial", jsonAttribute);
            }
            if (attribute.isHidden()) continue;
            for (Metadata m : attribute.metadata) {
                if (m.getName().equals("hidden") || !m.getModifiable().equals((Object)Modifiable.FIXED) || m.getValue() == null) continue;
                this.updated(attribute, (MetadataDescription)m.getDescription());
            }
        }
        ((ModelInstance)this.modelInstance).postMessage(notification);
    }

    @Override
    public void stop() {
        int length;
        if (this.isHidden()) {
            return;
        }
        AccessMethod.Type[] types = AccessMethod.Type.values();
        int n = length = types == null ? 0 : types.length;
        for (int index = 0; index < length; ++index) {
            AccessMethod<?, ?> method = this.methods.remove(types[index].name());
            if (method == null) continue;
            ((AbstractAccessMethod)method).stop();
        }
        super.stop();
    }

    @Override
    protected <TASK> TASK passOn(String type, String uri, Object[] parameters) throws Exception {
        if (!type.equals(AccessMethod.GET) || this.getUpdatePolicy() == Resource.UpdatePolicy.NONE || this.getUpdatePolicy() == Resource.UpdatePolicy.INIT) {
            if (type.equals(AccessMethod.GET) && this.getUpdatePolicy() == Resource.UpdatePolicy.INIT) {
                this.setUpdatePolicy(Resource.UpdatePolicy.AUTO);
            }
            return super.passOn(type, uri, parameters);
        }
        return null;
    }

    void registerMethod(AccessMethod.Type type, AccessMethod<?, ?> method) {
        if (this.methods.get(type) == null) {
            this.methods.put(type, method);
        }
    }

    @Override
    protected Class<? extends ElementsProxy<AttributeDescription>> getProxyType() {
        return this.resourceType;
    }

    @Override
    protected SnaLifecycleMessage.Lifecycle getRegisteredEvent() {
        return SnaLifecycleMessage.Lifecycle.RESOURCE_APPEARING;
    }

    @Override
    protected SnaLifecycleMessage.Lifecycle getUnregisteredEvent() {
        return SnaLifecycleMessage.Lifecycle.RESOURCE_DISAPPEARING;
    }

    public void setUpdatePolicy(Resource.UpdatePolicy updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public Resource.UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    @Override
    public ResourceProxy getProxy(List<MethodAccessibility> methodAccessibilities) {
        ResourceProxy proxy = new ResourceProxy(((ModelInstance)this.modelInstance).mediator(), this, methodAccessibilities);
        return proxy;
    }

    @Override
    protected AttributeDescription getElementProxy(AccessTree<?> tree, Attribute element) throws ModelElementProxyBuildException {
        if (element.isHidden()) {
            return null;
        }
        return (AttributeDescription)element.getDescription();
    }

    @Override
    protected ModelElement.ModelElementProxyWrapper getWrapper(ResourceProxy proxy, ImmutableAccessTree tree) {
        ResourceProxyWrapper wrapper = new ResourceProxyWrapper(proxy, tree);
        return wrapper;
    }

    public class ResourceProxyWrapper
    extends ModelElement.ModelElementProxyWrapper
    implements Typable<Resource.Type> {
        ResourceProxyWrapper(ResourceProxy proxy, ImmutableAccessTree tree) {
            super((ModelElement)ResourceImpl.this, (ModelElementProxy)proxy, tree);
        }

        public Resource.Type getType() {
            return ResourceImpl.this.getType();
        }

        public boolean isAccessible() {
            return true;
        }

        public Description getDescription() {
            return new Description(){

                public String getName() {
                    return ResourceImpl.this.getName();
                }

                public String getJSON() {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append('{');
                    buffer.append('\"');
                    buffer.append("name");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('\"');
                    buffer.append(this.getName());
                    buffer.append('\"');
                    buffer.append(',');
                    buffer.append('\"');
                    buffer.append("type");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('\"');
                    buffer.append(ResourceProxyWrapper.this.getType().name());
                    buffer.append('\"');
                    switch (ResourceProxyWrapper.this.getType()) {
                        case ACTION: {
                            break;
                        }
                        case PROPERTY: 
                        case SENSOR: 
                        case STATE_VARIABLE: {
                            buffer.append(',');
                            buffer.append('\"');
                            buffer.append("rws");
                            buffer.append('\"');
                            buffer.append(':');
                            buffer.append('\"');
                            switch (((AttributeDescription)ResourceProxyWrapper.this.element("value")).getModifiable()) {
                                case MODIFIABLE: {
                                    buffer.append("RW");
                                    break;
                                }
                                case FIXED: 
                                case UPDATABLE: {
                                    buffer.append("RO");
                                    break;
                                }
                            }
                            buffer.append('\"');
                            break;
                        }
                    }
                    buffer.append('}');
                    return buffer.toString();
                }

                public String getJSONDescription() {
                    try {
                        StringBuilder buffer = new StringBuilder();
                        buffer.append('{');
                        buffer.append('\"');
                        buffer.append("name");
                        buffer.append('\"');
                        buffer.append(':');
                        buffer.append('\"');
                        buffer.append(this.getName());
                        buffer.append('\"');
                        buffer.append(',');
                        buffer.append('\"');
                        buffer.append("type");
                        buffer.append('\"');
                        buffer.append(':');
                        buffer.append('\"');
                        buffer.append(ResourceProxyWrapper.this.getType().name());
                        buffer.append('\"');
                        buffer.append(',');
                        buffer.append('\"');
                        buffer.append("attributes");
                        buffer.append('\"');
                        buffer.append(':');
                        buffer.append('[');
                        int index = 0;
                        Enumeration enumeration = ResourceProxyWrapper.this.elements();
                        while (enumeration.hasMoreElements()) {
                            buffer.append(index > 0 ? Character.valueOf(',') : "");
                            buffer.append(((AttributeDescription)((Object)enumeration.nextElement())).getJSONDescription());
                            ++index;
                        }
                        buffer.append(']');
                        buffer.append(',');
                        buffer.append('\"');
                        buffer.append("accessMethods");
                        buffer.append('\"');
                        buffer.append(':');
                        buffer.append('[');
                        int pos = 0;
                        AccessMethod.Type[] types = AccessMethod.Type.values();
                        for (index = 0; index < types.length; ++index) {
                            AccessMethod<?, ?> m = ((ResourceProxy)ResourceProxyWrapper.this.proxy).getAccessMethod(types[index].name());
                            if (m == null || m.size() <= 0) continue;
                            buffer.append(pos > 0 ? Character.valueOf(',') : "");
                            buffer.append(m.getDescription().getJSONDescription());
                            ++pos;
                        }
                        buffer.append(']');
                        buffer.append('}');
                        return buffer.toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }
    }
}

