/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.Description;
import org.eclipse.sensinact.gateway.common.primitive.ElementsProxy;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.DataResource;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.InvalidServiceException;
import org.eclipse.sensinact.gateway.core.LinkedResourceImpl;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelElement;
import org.eclipse.sensinact.gateway.core.ModelElementProxy;
import org.eclipse.sensinact.gateway.core.ModelElementProxyBuildException;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceBuilder;
import org.eclipse.sensinact.gateway.core.ResourceCollection;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ResourceProcessableData;
import org.eclipse.sensinact.gateway.core.Service;
import org.eclipse.sensinact.gateway.core.ServiceProcessableData;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.ServiceProxy;
import org.eclipse.sensinact.gateway.core.StateVariableResource;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.InvalidTriggerException;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.eclipse.sensinact.gateway.core.method.trigger.AccessMethodTrigger;
import org.eclipse.sensinact.gateway.core.method.trigger.TriggerArgumentBuilder;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.core.security.ImmutableAccessTree;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceImpl
extends ModelElement<ModelInstance<?>, ServiceProxy, ServiceProcessableData<?>, ResourceImpl, Resource> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceImpl.class);
    protected int subscriptionsCount = 0;

    protected ServiceImpl(ModelInstance<?> modelInstance, String name, ServiceProviderImpl serviceProvider) throws InvalidServiceException {
        super(modelInstance, serviceProvider, UriUtils.getUri((String[])new String[]{serviceProvider.getPath(), name}));
    }

    @Override
    public void process(ServiceProcessableData<?> data) {
        if (data == null) {
            return;
        }
        String resourceId = data.getResourceId();
        if (resourceId == null) {
            LOG.warn("Resource identifier not found");
            return;
        }
        ResourceImpl resource = this.getResource(resourceId);
        if (resource == null) {
            Class dataType = null;
            Iterator it = data.iterator();
            while (it.hasNext()) {
                Class<?> clazz;
                ResourceProcessableData rpd = (ResourceProcessableData)it.next();
                if (rpd.getAttributeId() != null && !"value".equals(rpd.getAttributeId())) continue;
                Object obj = rpd.getData();
                Class<?> clazz2 = clazz = obj == null ? null : obj.getClass();
                if (clazz == null) break;
                if (clazz.isPrimitive()) {
                    switch (clazz.getName()) {
                        case "byte": 
                        case "short": 
                        case "int": 
                        case "long": 
                        case "float": 
                        case "double": {
                            dataType = Double.TYPE;
                            break;
                        }
                        case "boolean": {
                            dataType = Boolean.TYPE;
                            break;
                        }
                        case "char": {
                            dataType = String.class;
                        }
                    }
                    break;
                }
                if (obj instanceof Number) {
                    switch (clazz.getName()) {
                        case "java.lang.Byte": 
                        case "java.lang.Short": 
                        case "java.lang.Integer": 
                        case "java.lang.Long": 
                        case "java.lang.Float": 
                        case "java.lang.Double": {
                            dataType = Double.TYPE;
                            break;
                        }
                        default: {
                            dataType = String.class;
                            break;
                        }
                    }
                    break;
                }
                dataType = String.class;
                break;
            }
            ResourceDescriptor descriptor = ((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withServiceName(super.getName()).withResourceName(resourceId).withDataType(dataType);
            ResourceBuilder builder = ((ModelInstance)super.getModelInstance()).getResourceBuilder(descriptor, ((ModelConfiguration)this.modelInstance.configuration()).getResourceBuildPolicy());
            if (builder != null) {
                try {
                    resource = this.addResource(builder);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (resource == null) {
            LOG.warn("Resource '%s' not found for '%s' service", (Object)resourceId, (Object)super.getName());
            return;
        }
        resource.process(data);
    }

    public <D extends DataResource> ResourceImpl addDataResource(Class<D> resourceClass, String name, Class<?> type, Object value) throws InvalidResourceException {
        ResourceDescriptor descriptor = ((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withServiceName(this.getName()).withResourceName(name).withResourceType(resourceClass).withDataType(type).withDataValue(value);
        ResourceBuilder builder = ((ModelInstance)super.getModelInstance()).getResourceBuilder(descriptor, ((ModelConfiguration)this.modelInstance.configuration()).getResourceBuildPolicy());
        return this.addResource(builder);
    }

    public <D extends ActionResource> ResourceImpl addActionResource(String name, Class<D> resourceClass) throws InvalidResourceException {
        ResourceDescriptor descriptor = ((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withServiceName(this.getName()).withResourceName(name).withResourceType(resourceClass);
        ResourceBuilder builder = ((ModelInstance)super.getModelInstance()).getResourceBuilder(descriptor, ((ModelConfiguration)this.modelInstance.configuration()).getResourceBuildPolicy());
        return this.addResource(builder);
    }

    public ResourceImpl addLinkedResource(String link, ResourceImpl targetedResource) throws InvalidResourceException {
        if (targetedResource == null || this.getResource(link) != null || LinkedResourceImpl.class.isAssignableFrom(targetedResource.getClass())) {
            LOG.debug("Unable to create the linked resource : %s", (Object)link);
            return null;
        }
        if (targetedResource.getType() == Resource.Type.ACTION) {
            return this.addLinkedActionResource(link, targetedResource, true);
        }
        ResourceBuilder builder = ((ModelInstance)super.getModelInstance()).createResourceBuilder(((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withResourceName(link).withResourceType(targetedResource.getResourceType()));
        ResourceImpl linkedResource = builder.buildLinkedResource(this, targetedResource);
        if (this.addResource(linkedResource)) {
            targetedResource.registerLink(linkedResource.getPath());
        }
        return linkedResource;
    }

    public ResourceImpl addLinkedActionResource(String link, ResourceImpl targetedResource, boolean copyActMethod) throws InvalidResourceException {
        if (targetedResource == null || targetedResource.getType() != Resource.Type.ACTION || this.getResource(link) != null) {
            LOG.debug("Unable to create the resource - Invalid Name :" + link);
            return null;
        }
        ResourceBuilder builder = ((ModelInstance)super.getModelInstance()).createResourceBuilder(((ModelConfiguration)((ModelInstance)super.getModelInstance()).configuration()).getResourceDescriptor().withResourceName(link).withResourceType(targetedResource.getResourceType()));
        ResourceImpl linkedResource = builder.buildLinkedActionResource(this, targetedResource, copyActMethod);
        if (this.addResource(linkedResource)) {
            targetedResource.registerLink(linkedResource.getPath());
            return linkedResource;
        }
        return null;
    }

    public ResourceImpl addResource(ResourceBuilder builder) throws InvalidResourceException {
        String resourceName = builder.getConfiguredName();
        ResourceImpl resource = null;
        if (resourceName == null || (resource = this.getResource(resourceName)) != null) {
            LOG.debug("The resource '%s' already exists", (Object)resourceName);
            return null;
        }
        resource = builder.build((ModelInstance<?>)this.modelInstance, this);
        if (resource != null && this.addResource(resource)) {
            return resource;
        }
        return null;
    }

    private boolean addResource(ResourceImpl resource) {
        if (resource == null || !super.addElement(resource)) {
            return false;
        }
        if (((ModelInstance)this.modelInstance).isRegistered()) {
            resource.start();
        }
        return true;
    }

    public ResourceImpl removeResource(String resource) {
        return (ResourceImpl)super.removeElement(resource);
    }

    public void addTrigger(String listen, String target, Signature signature, final AccessMethodTrigger trigger, AccessMethodExecutor.ExecutionPolicy policy) throws InvalidValueException {
        if (!signature.getName().equals(AccessMethod.ACT) && !signature.getName().equals(AccessMethod.SET)) {
            throw new InvalidTriggerException(String.format("ACT or SET method expected", new Object[0]));
        }
        ResourceImpl listened = this.getResource(listen);
        final ResourceImpl variable = this.getResource(target);
        if (listened == null || variable == null) {
            throw new InvalidTriggerException("Both observed and updated Resources are required");
        }
        Class resourceType = listened.getResourceType();
        if (signature.getName().equals(AccessMethod.ACT) && !ActionResource.class.isAssignableFrom(resourceType) || signature.getName().equals(AccessMethod.SET) && !DataResource.class.isAssignableFrom(resourceType) || !StateVariableResource.class.isAssignableFrom(variable.getResourceType())) {
            throw new InvalidTriggerException(String.format("An %s and a StateVariableResource were expected", resourceType.getSimpleName()));
        }
        final Attribute attribute = variable.getAttribute(variable.getDefault());
        if (Modifiable.FIXED.equals((Object)attribute.getModifiable())) {
            throw new InvalidValueException("Trigger cannot modify the resource value");
        }
        attribute.lock();
        listened.registerExecutor(signature, new AccessMethodExecutor(){

            public Void execute(AccessMethodResponseBuilder builder) throws Exception {
                Object result = null;
                switch (trigger.getArgumentBuilder()) {
                    case "EMPTY": {
                        result = trigger.execute(new TriggerArgumentBuilder.Empty().build(null));
                        break;
                    }
                    case "PARAMETER": {
                        result = trigger.execute(new TriggerArgumentBuilder.Parameter((Integer)trigger.getArgument()).build(builder));
                        break;
                    }
                    case "RESPONSE": {
                        result = trigger.execute(new TriggerArgumentBuilder.Response().build(builder));
                        break;
                    }
                    case "INTERMEDIATE": {
                        result = trigger.execute(new TriggerArgumentBuilder.Intermediate().build(builder));
                        break;
                    }
                    case "MODEL": {
                        result = trigger.execute(new TriggerArgumentBuilder.Model((String)trigger.getArgument()).build(ServiceImpl.this).getValue());
                        break;
                    }
                }
                if (trigger.passOn()) {
                    ServiceImpl.this.passOn(AccessMethod.SET, variable.getPath(), new Object[]{"value", result});
                }
                attribute.setValue(result);
                builder.push(new JSONObject(attribute.getDescription().getJSON()));
                return null;
            }
        }, policy);
    }

    public Executable<Void, Object> getResourceValueExtractor(String resourceName) {
        String defaultAttributeName = null;
        ResourceImpl resource = this.getResource(resourceName);
        final Attribute attribute = resource != null && (defaultAttributeName = resource.getDefault()) != null ? resource.getAttribute(defaultAttributeName) : null;
        return new Executable<Void, Object>(){

            public Object execute(Void parameter) throws Exception {
                if (attribute != null) {
                    return attribute.getValue();
                }
                return null;
            }
        };
    }

    @Override
    protected <TASK> TASK passOn(String type, String path, Object[] parameters) throws Exception {
        this.subscriptionsCount += type == AccessMethod.UNSUBSCRIBE ? -1 : 0;
        Object task = super.passOn(type, path, parameters);
        this.subscriptionsCount += type == AccessMethod.SUBSCRIBE ? 1 : 0;
        return task;
    }

    public ResourceImpl getResource(String resource) {
        return (ResourceImpl)super.element(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceImpl> getResources() {
        List list = this.elements;
        synchronized (list) {
            return Collections.unmodifiableList(this.elements);
        }
    }

    public int getSubscriptionsCount() {
        return this.subscriptionsCount;
    }

    @Override
    protected SnaLifecycleMessage.Lifecycle getRegisteredEvent() {
        return SnaLifecycleMessage.Lifecycle.SERVICE_APPEARING;
    }

    @Override
    protected SnaLifecycleMessage.Lifecycle getUnregisteredEvent() {
        return SnaLifecycleMessage.Lifecycle.SERVICE_DISAPPEARING;
    }

    @Override
    protected Class<? extends ElementsProxy<Resource>> getProxyType() {
        return Service.class;
    }

    @Override
    public ServiceProxy getProxy(List<MethodAccessibility> methodAccessibilities) {
        try {
            ServiceProxy proxy = new ServiceProxy(((ModelInstance)this.modelInstance).mediator(), super.getPath());
            proxy.buildMethods(null, methodAccessibilities);
            return proxy;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected Resource getElementProxy(AccessTree<?> tree, ResourceImpl element) throws ModelElementProxyBuildException {
        if (element.isHidden()) {
            return null;
        }
        return (Resource)element.getProxy(tree);
    }

    @Override
    protected ModelElement.ModelElementProxyWrapper getWrapper(ServiceProxy proxy, ImmutableAccessTree tree) {
        ServiceProxyWrapper wrapper = new ServiceProxyWrapper(proxy, tree);
        return wrapper;
    }

    class ServiceProxyWrapper
    extends ModelElement.ModelElementProxyWrapper
    implements ResourceCollection {
        protected ServiceProxyWrapper(ServiceProxy proxy, ImmutableAccessTree tree) {
            super((ModelElement)ServiceImpl.this, (ModelElementProxy)proxy, tree);
        }

        @Override
        public List<Resource> getResources() {
            return super.list();
        }

        @Override
        public <R extends Resource> R getResource(String resource) {
            return (R)((Resource)super.element(resource));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
            AccessMethodResponse<?> result = null;
            if (((ServiceProxy)this.proxy).getProxied().isAssignableFrom(method.getDeclaringClass())) {
                Object[] calledParameters = null;
                calledParameters = method.isVarArgs() && parameters != null && parameters.length == 1 && parameters[0].getClass().isArray() ? (Object[])parameters[0] : parameters;
                if (calledParameters.length > 0) {
                    String resourceName = (String)calledParameters[0];
                    calledParameters[0] = this.getResource(resourceName);
                }
                result = ((ServiceProxy)this.proxy).invoke(method.getName().toUpperCase(), calledParameters);
            } else {
                result = method.invoke((Object)this, parameters);
            }
            if (result == this.proxy || result == this) {
                return proxy;
            }
            return result;
        }

        public boolean isAccessible() {
            return true;
        }

        public Description getDescription() {
            return new Description(){

                public String getName() {
                    return ServiceImpl.this.getName();
                }

                public String getJSON() {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append('{');
                    buffer.append('\"');
                    buffer.append("name");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('\"');
                    buffer.append(this.getName());
                    buffer.append('\"');
                    buffer.append(',');
                    buffer.append('\"');
                    buffer.append("resources");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('[');
                    int index = 0;
                    Enumeration enumeration = ServiceProxyWrapper.this.elements();
                    while (enumeration.hasMoreElements()) {
                        buffer.append(index > 0 ? Character.valueOf(',') : "");
                        buffer.append(((Resource)enumeration.nextElement()).getDescription().getJSON());
                        ++index;
                    }
                    buffer.append(']');
                    buffer.append('}');
                    return buffer.toString();
                }

                public String getJSONDescription() {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append('{');
                    buffer.append('\"');
                    buffer.append("name");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('\"');
                    buffer.append(this.getName());
                    buffer.append('\"');
                    buffer.append(',');
                    buffer.append('\"');
                    buffer.append("resources");
                    buffer.append('\"');
                    buffer.append(':');
                    buffer.append('[');
                    int index = 0;
                    Enumeration enumeration = ServiceProxyWrapper.this.elements();
                    while (enumeration.hasMoreElements()) {
                        buffer.append(index > 0 ? Character.valueOf(',') : "");
                        buffer.append(((Resource)enumeration.nextElement()).getDescription().getJSONDescription());
                        ++index;
                    }
                    buffer.append(']');
                    buffer.append('}');
                    return buffer.toString();
                }
            };
        }
    }
}

