/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.SnaAgent;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAgent
implements SnaAgent {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAgent.class);
    protected Mediator mediator;
    protected final MidAgentCallback callback;
    protected SnaFilter filter;
    protected final String publicKey;
    protected ServiceRegistration<?> registration;

    public abstract String[] getAgentInterfaces();

    public abstract void doStart();

    public abstract void doStop();

    protected AbstractAgent(Mediator mediator, MidAgentCallback callback, SnaFilter filter, String publicKey) {
        this.mediator = mediator;
        this.callback = callback;
        this.publicKey = publicKey;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(SnaMessage<?> message) {
        AbstractAgent abstractAgent = this;
        synchronized (abstractAgent) {
            if (!this.callback.isActive()) {
                this.stop();
                return;
            }
            if (this.filter == null || this.filter.matches(message)) {
                this.callback.getMessageRegisterer().register(message);
            }
        }
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        AbstractAgent abstractAgent = this;
        synchronized (abstractAgent) {
            if (!this.callback.isActive()) {
                LOG.error("The agent cannot be registered while its callback is inactive");
                return;
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("org.eclipse.sensinact.gateway.agent.id", this.callback.getName());
            try {
                this.registration = this.mediator.getContext().registerService(this.getAgentInterfaces(), (Object)this, properties);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error("The agent is not registered ", (Throwable)e);
            }
            this.doStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        AbstractAgent abstractAgent = this;
        synchronized (abstractAgent) {
            if (this.callback.isActive()) {
                try {
                    this.callback.stop();
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.registration != null) {
                try {
                    this.registration.unregister();
                    this.registration = null;
                }
                catch (IllegalStateException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            this.doStop();
        }
    }
}

