/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.gateway.common.execution.DefaultErrorHandler;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.core.message.MessageRegisterer;
import org.eclipse.sensinact.gateway.core.message.MidCallback;
import org.eclipse.sensinact.gateway.core.message.MidCallbackException;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.util.stack.AbstractStackEngineHandler;

public abstract class AbstractMidCallback
implements MidCallback {
    protected ErrorHandler errorHandler;
    protected long timeout;
    protected MessageRegisterer registerer;
    protected String identifier;
    protected AtomicBoolean isActive;

    protected abstract void doCallback(SnaMessage<?> var1) throws MidCallbackException;

    protected AbstractMidCallback() {
        this(false, null);
    }

    protected AbstractMidCallback(String identifier) {
        this(false, identifier);
    }

    protected AbstractMidCallback(boolean buffer) {
        this(buffer, null);
    }

    protected AbstractMidCallback(boolean buffer, String identifier) {
        this.setTimeout(-1L);
        this.registerer = buffer ? new MessageRegistererBufferDelegate() : new MessageRegistererDirectDelegate();
        this.isActive = new AtomicBoolean(true);
        this.identifier = identifier == null ? "MID" + System.currentTimeMillis() + this.hashCode() : identifier;
    }

    public String getName() {
        return this.identifier;
    }

    @Override
    public ErrorHandler getCallbackErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler();
        }
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    protected void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public MessageRegisterer getMessageRegisterer() {
        return this.registerer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        AtomicBoolean atomicBoolean = this.isActive;
        synchronized (atomicBoolean) {
            return this.isActive.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AtomicBoolean atomicBoolean = this.isActive;
        synchronized (atomicBoolean) {
            this.isActive.set(false);
        }
        if (MessageRegistererBufferDelegate.class.isAssignableFrom(this.registerer.getClass())) {
            ((MessageRegistererBufferDelegate)this.registerer).stop();
        }
    }

    class MessageRegistererBufferDelegate
    extends AbstractStackEngineHandler<SnaMessage<?>>
    implements MessageRegisterer {
        MessageRegistererBufferDelegate() {
        }

        public void doHandle(SnaMessage<?> message) {
            try {
                AbstractMidCallback.this.doCallback(message);
            }
            catch (MidCallbackException e) {
                int continuation = AbstractMidCallback.this.getCallbackErrorHandler().handle((Exception)e);
                switch (continuation) {
                    case 1: 
                    case 256: 
                    case 4096: {
                        break;
                    }
                    case 16: {
                        AbstractMidCallback.this.stop();
                    }
                }
            }
        }

        @Override
        public void register(SnaMessage<?> message) {
            this.eventEngine.push(message);
        }
    }

    class MessageRegistererDirectDelegate
    implements MessageRegisterer {
        MessageRegistererDirectDelegate() {
        }

        @Override
        public void register(SnaMessage<?> message) {
            try {
                AbstractMidCallback.this.doCallback(message);
            }
            catch (MidCallbackException e) {
                int continuation = AbstractMidCallback.this.getCallbackErrorHandler().handle((Exception)e);
                switch (continuation) {
                    case 1: 
                    case 256: 
                    case 4096: {
                        break;
                    }
                    case 16: {
                        AbstractMidCallback.this.stop();
                    }
                }
            }
        }
    }
}

