/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.core.message.MidCallbackException;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.UnaryMidCallback;

public class BufferMidCallback
extends UnaryMidCallback {
    protected int length;
    protected final int bufferSize;
    protected final SnaMessage<?>[] buffer;

    public BufferMidCallback(Mediator mediator, ErrorHandler errorHandler, Recipient recipient, long timeout, int bufferSize) {
        super(mediator, errorHandler, recipient, timeout);
        this.bufferSize = bufferSize == 0 ? 1 : bufferSize;
        this.length = 0;
        this.buffer = new SnaMessage[this.bufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCallback(SnaMessage<?> message) throws MidCallbackException {
        SnaMessage<?>[] snaMessageArray = this.buffer;
        synchronized (this.buffer) {
            this.buffer[this.length++] = message;
            if (this.length == this.bufferSize) {
                SnaMessage[] msgBuffer = new SnaMessage[this.length];
                for (int index = 0; index < this.length; ++index) {
                    msgBuffer[index] = this.buffer[index];
                }
                try {
                    this.recipient.callback(this.getName(), msgBuffer);
                }
                catch (Exception e) {
                    throw new MidCallbackException(e);
                }
                this.length = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

