/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.core.message.LocalAgent;
import org.eclipse.sensinact.gateway.core.message.SnaAgent;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;
import org.eclipse.sensinact.gateway.core.message.SnaNotificationMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaRemoteMessage;
import org.eclipse.sensinact.gateway.core.remote.RemoteCore;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.eclipse.sensinact.gateway.util.stack.AbstractStackEngineHandler;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceIntent
extends AbstractStackEngineHandler<SnaMessage<?>>
implements LocalAgent,
Nameable {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceIntent.class);
    private static final String LOCAL_NAMESPACE = "#LOCAL#";
    private String publicKey;
    private String identifier;
    private ExecutorService executor;
    private SnaFilter filter;
    private Executable<Boolean, Void> onAccessible;
    private Map<ResolvedPath, Boolean> accessibility;
    private Map<String, String> filters;
    private Mediator mediator;
    private boolean accessible;
    private String commonPath;
    private ServiceRegistration<?> registration;

    public abstract boolean isAccessible(String var1);

    public abstract String namespace();

    public ResourceIntent(Mediator mediator, String publicKey, Executable<Boolean, Void> onAccessible, String ... resourcePath) {
        if (resourcePath == null || resourcePath.length == 0) {
            throw new NullPointerException("Nothing to observed");
        }
        this.mediator = mediator;
        this.accessibility = new HashMap<ResolvedPath, Boolean>();
        this.filters = new HashMap<String, String>();
        int length = resourcePath.length;
        boolean pattern = length > 1;
        boolean complement = false;
        StringBuilder filterBuilder = new StringBuilder();
        if (pattern) {
            filterBuilder.append("(");
        }
        ResolvedPath path = null;
        for (int index = 0; index < length; ++index) {
            path = new ResolvedPath(resourcePath[index]);
            this.accessibility.put(path, false);
            if (index > 0) {
                filterBuilder.append("|");
            }
            if (pattern) {
                filterBuilder.append("(");
            }
            filterBuilder.append(path.getName());
            if (pattern) {
                filterBuilder.append(")");
            }
            if (LOCAL_NAMESPACE.equals(path.getNamespace().getName())) continue;
            String fltr = this.filters.get(path.getNamespace().getName());
            fltr = fltr == null ? path.getName() : (fltr.endsWith("))") ? fltr.substring(0, fltr.length() - 1) + "(" + path.getName() + "))" : "(|(" + fltr + ")(" + path.getName() + "))");
            this.filters.put(path.getNamespace().getName(), fltr);
        }
        if (pattern) {
            filterBuilder.append(")");
        }
        this.commonPath = this.accessibility.size() == 1 ? path.getName() : "/";
        this.filter = new SnaFilter(mediator, filterBuilder.toString(), pattern, complement);
        this.filter.addHandledType(SnaMessage.Type.LIFECYCLE);
        this.filter.addHandledType(SnaMessage.Type.REMOTE);
        this.identifier = "INT" + System.currentTimeMillis() + (this.accessibility.hashCode() + this.hashCode());
        this.publicKey = publicKey;
        this.onAccessible = onAccessible;
        this.executor = Executors.newCachedThreadPool();
    }

    public String getCommonPath() {
        return this.commonPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAccessible() {
        boolean accessibleAll = true;
        Map<ResolvedPath, Boolean> map = this.accessibility;
        synchronized (map) {
            Iterator<Boolean> iterator = this.accessibility.values().iterator();
            while (iterator.hasNext()) {
                accessibleAll &= iterator.next().booleanValue();
            }
        }
        this.setAccessible(accessibleAll);
    }

    private synchronized void setAccessible(final boolean accessible) {
        if (this.accessible && accessible || !this.accessible && !accessible) {
            return;
        }
        this.accessible = accessible;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ResourceIntent.this.onAccessible.execute((Object)accessible);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setAccessible(String path, boolean accessible) {
        Map<ResolvedPath, Boolean> map = this.accessibility;
        synchronized (map) {
            this.accessibility.put(new ResolvedPath(path), accessible);
            if (!accessible) {
                return false;
            }
            Iterator<Boolean> iterator = this.accessibility.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void register(SnaMessage<?> message) {
        this.eventEngine.push(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doHandle(SnaMessage<?> message) {
        switch (((SnaMessageSubType)((Object)message.getType())).getSnaMessageType()) {
            case LIFECYCLE: {
                if (!this.filter.matches(message)) {
                    return;
                }
                switch ((SnaLifecycleMessage.Lifecycle)message.getType()) {
                    case RESOURCE_APPEARING: {
                        this.setAccessible(this.setAccessible(message.getPath(), true));
                        return;
                    }
                    case RESOURCE_DISAPPEARING: {
                        this.setAccessible(this.setAccessible(message.getPath(), false));
                        return;
                    }
                }
                return;
            }
            case REMOTE: {
                if (this.filters.isEmpty()) {
                    return;
                }
                String namespace = ((SnaNotificationMessageImpl)message).getNotification(String.class, "namespace");
                if (!this.filters.containsKey(namespace)) {
                    return;
                }
                ResolvedPath[] paths = null;
                ResolvedPath[] resolvedPathArray = this.accessibility;
                synchronized (this.accessibility) {
                    paths = this.accessibility.keySet().toArray(new ResolvedPath[this.filters.size()]);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    block15: for (ResolvedPath path : paths) {
                        if (!namespace.equals(path.getNamespace().getName())) continue;
                        switch ((SnaRemoteMessage.Remote)message.getType()) {
                            case CONNECTED: {
                                this.setAccessible(path.getName(), this.isAccessible(path.getName()));
                                continue block15;
                            }
                            case DISCONNECTED: {
                                this.setAccessible(path.getName(), false);
                                continue block15;
                            }
                        }
                    }
                    this.setAccessible();
                    return;
                }
            }
        }
    }

    public String getName() {
        return this.identifier;
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    protected void registerRemote() {
        if (this.filters.size() == 0) {
            return;
        }
        this.mediator.callServices(RemoteCore.class, (Executable)new Executable<RemoteCore, Void>(){

            public Void execute(RemoteCore remoteCore) throws Exception {
                ResourceIntent.this.registerRemote(remoteCore);
                return null;
            }
        });
    }

    @Override
    public void registerRemote(RemoteCore remoteCore) {
        if (remoteCore != null && this.filters.size() > 0 && this.filters.containsKey(remoteCore.endpoint().namespace())) {
            String sender = this.filters.get(remoteCore.endpoint().namespace());
            boolean pattern = sender.endsWith("))");
            boolean complement = false;
            SnaFilter filter = new SnaFilter(this.mediator, sender, pattern, complement);
            filter.addHandledType(SnaMessage.Type.LIFECYCLE);
            remoteCore.endpoint().registerAgent(this.identifier, filter, this.publicKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("org.eclipse.sensinact.gateway.agent.id", this.identifier);
        try {
            this.registration = this.mediator.getContext().registerService(new String[]{SnaAgent.class.getName(), LocalAgent.class.getName()}, (Object)this, properties);
            this.registerRemote();
        }
        catch (IllegalStateException e) {
            LOG.error("The agent is not registered ", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<ResolvedPath, Boolean> map = this.accessibility;
        synchronized (map) {
            for (Map.Entry<ResolvedPath, Boolean> entry : this.accessibility.entrySet()) {
                boolean acc = this.isAccessible(entry.getKey().getName());
                entry.setValue(acc);
            }
        }
        this.setAccessible();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.filters.size() > 0) {
            StringBuilder filterBuilder = new StringBuilder();
            Iterator<String> iterator = this.filters.keySet().iterator();
            while (iterator.hasNext()) {
                filterBuilder.append("(namespace=").append(iterator.next()).append(")");
            }
            if (this.filters.size() > 1) {
                filterBuilder.insert(0, "(|");
                filterBuilder.append(")");
            }
            this.mediator.callService(RemoteCore.class, filterBuilder.toString(), (Executable)new Executable<RemoteCore, Void>(){

                public Void execute(RemoteCore remoteCore) throws Exception {
                    remoteCore.endpoint().unregisterAgent(ResourceIntent.this.identifier);
                    return null;
                }
            });
        }
        if (this.registration != null) {
            try {
                this.registration.unregister();
                this.registration = null;
            }
            catch (IllegalStateException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private final class ResolvedPath
    implements Nameable {
        final Namespace namespace;
        final String path;

        ResolvedPath(String path) {
            String[] uriElements = UriUtils.getUriElements((String)path);
            String[] providerElements = uriElements[0].split(":");
            if (providerElements.length == 1) {
                this.namespace = new Namespace(ResourceIntent.LOCAL_NAMESPACE);
                this.path = path;
            } else if (providerElements[0].equals(ResourceIntent.this.namespace())) {
                this.namespace = new Namespace(ResourceIntent.LOCAL_NAMESPACE);
                this.path = UriUtils.getUri((String[])new String[]{providerElements[1], UriUtils.getUri((String[])Arrays.copyOfRange(uriElements, 1, uriElements.length))});
            } else {
                this.namespace = new Namespace(providerElements[0]);
                this.path = path;
            }
        }

        public String getName() {
            return this.path;
        }

        Namespace getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object o) {
            if (String.class == o.getClass()) {
                return this.path.equals(o);
            }
            if (Nameable.class.isAssignableFrom(o.getClass())) {
                return this.path.equals(((Nameable)o).getName());
            }
            if (Namespace.class.isAssignableFrom(o.getClass())) {
                return this.namespace.equals(o);
            }
            if (ResolvedPath.class.isAssignableFrom(o.getClass())) {
                return this.path.equals(((ResolvedPath)o).getName());
            }
            return false;
        }

        public int hashCode() {
            return this.namespace.hashCode() + this.path.hashCode();
        }
    }

    private class Namespace
    implements Nameable {
        final String namespace;

        Namespace(String namespace) {
            this.namespace = namespace;
        }

        public String getName() {
            return this.namespace;
        }

        public boolean equals(Object o) {
            if (String.class == o.getClass()) {
                return this.namespace.equals(o);
            }
            if (Nameable.class.isAssignableFrom(o.getClass())) {
                return this.namespace.equals(((Nameable)o).getName());
            }
            if (Namespace.class.isAssignableFrom(o.getClass())) {
                return this.namespace.equals(((Namespace)o).getName());
            }
            if (ResolvedPath.class.isAssignableFrom(o.getClass())) {
                return this.namespace.equals(((ResolvedPath)o).getNamespace().getName());
            }
            return false;
        }

        public int hashCode() {
            return this.namespace.hashCode();
        }
    }
}

