/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.List;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.InvalidServiceException;
import org.eclipse.sensinact.gateway.core.ResourceBuilder;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.eclipse.sensinact.gateway.core.method.trigger.AccessMethodTriggerFactory;
import org.eclipse.sensinact.gateway.generic.ExtModelInstance;
import org.eclipse.sensinact.gateway.generic.ExtResourceConfig;
import org.eclipse.sensinact.gateway.generic.ExtResourceImpl;
import org.eclipse.sensinact.gateway.generic.parser.ReferenceDefinition;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtServiceImpl
extends ServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ExtServiceImpl.class);
    protected final String defaultResourceConfig;

    public ExtServiceImpl(ExtModelInstance<?> snaModelInstance, String name, ServiceProviderImpl serviceProvider) throws InvalidServiceException {
        this(snaModelInstance, name, serviceProvider, null);
    }

    public ExtServiceImpl(ExtModelInstance<?> snaModelInstance, String name, ServiceProviderImpl serviceProvider, String defaultResourceConfig) throws InvalidServiceException {
        super(snaModelInstance, name, serviceProvider);
        this.defaultResourceConfig = defaultResourceConfig;
    }

    public ResourceImpl addResource(ResourceBuilder builder) throws InvalidResourceException {
        ExtResourceImpl resource = (ExtResourceImpl)super.addResource(builder);
        if (resource != null) {
            ExtResourceConfig resourceConfig = (ExtResourceConfig)builder.getResourceConfig();
            resource.buildMethod(resourceConfig, this);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildTriggers(String resourceName, Signature signature, List<ReferenceDefinition> references) {
        if (signature.getName().intern() != AccessMethod.ACT && signature.getName().intern() != AccessMethod.SET) {
            LOG.debug("Trigger allowed for ACT and SET methods only");
            return;
        }
        int length = references == null ? 0 : references.size();
        AccessMethodTriggerFactory.Loader loader = (AccessMethodTriggerFactory.Loader)AccessMethodTriggerFactory.LOADER.get();
        try {
            for (int index = 0; index < length; ++index) {
                JSONObject referenceJson = new JSONObject(references.get(index).getJSON());
                JSONObject triggerJson = referenceJson.getJSONObject("trigger");
                AccessMethodTriggerFactory factory = loader.load(this.modelInstance.mediator(), triggerJson.getString("type"));
                super.addTrigger(resourceName, referenceJson.getString("reference"), signature, factory.newInstance(this.modelInstance.mediator(), triggerJson), AccessMethodExecutor.ExecutionPolicy.AFTER);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            AccessMethodTriggerFactory.LOADER.remove();
        }
    }
}

