/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.signature.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.security.signature.internal.CryptographicUtils;
import org.eclipse.sensinact.gateway.util.IOUtils;

public class SignedBundleManifest
extends Manifest {
    private CryptographicUtils cryptoUtils;

    public SignedBundleManifest(InputStream iStream, CryptographicUtils cryptoUtils) throws IOException {
        super(iStream);
        this.cryptoUtils = cryptoUtils;
    }

    public static byte[] getManifestMainAttributesAsBytes(Manifest manifest) throws IOException {
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        manifest.write(oStream);
        oStream.flush();
        byte[] manifestData = oStream.toByteArray();
        return SignedBundleManifest.getManifestMainAttributesAsBytes(manifestData);
    }

    public static byte[] getManifestMainAttributesAsBytes(byte[] rawData) throws IOException {
        byte[] manifestMainAtts = null;
        if (rawData != null) {
            int mainAttsLength = SignedBundleManifest.getMainAttributesLength(rawData);
            manifestMainAtts = new byte[mainAttsLength];
            System.arraycopy(rawData, 0, manifestMainAtts, 0, mainAttsLength);
        }
        if (manifestMainAtts == null) {
            manifestMainAtts = new byte[]{};
        }
        return manifestMainAtts;
    }

    public static byte[] getManifestMainAttributesAsBytes(Mediator mediator, InputStream manifestInputStream) throws IOException {
        byte[] rawData = IOUtils.read((InputStream)manifestInputStream);
        return SignedBundleManifest.getManifestMainAttributesAsBytes(rawData);
    }

    public static int getMainAttributesLength(byte[] rawManifestData) {
        int startOfNext = 0;
        if (rawManifestData != null) {
            int k = rawManifestData.length;
            boolean flag = true;
            block4: for (int j = 0; j < k; ++j) {
                byte byte0 = rawManifestData[j];
                switch (byte0) {
                    case 13: {
                        if (j < k && rawManifestData[j + 1] == 10) {
                            ++j;
                        }
                    }
                    case 10: {
                        if (flag || j == k - 1) {
                            startOfNext = j + 1;
                            return startOfNext;
                        }
                        flag = true;
                        continue block4;
                    }
                    default: {
                        flag = false;
                    }
                }
            }
        }
        return startOfNext;
    }
}

