/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.impl;

import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.core.notification.ClientDataListener;
import org.eclipse.sensinact.core.notification.ClientLifecycleListener;
import org.eclipse.sensinact.northbound.query.api.AbstractQueryDTO;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.IQueryHandler;
import org.eclipse.sensinact.northbound.query.dto.SensinactPath;
import org.eclipse.sensinact.northbound.query.dto.notification.ResourceDataNotificationDTO;
import org.eclipse.sensinact.northbound.query.dto.notification.ResourceLifecycleNotificationDTO;
import org.eclipse.sensinact.northbound.query.dto.query.AccessMethodCallParameterDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryActDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryDescribeDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryGetDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryListDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QuerySetDTO;
import org.eclipse.sensinact.northbound.query.dto.query.WrappedAccessMethodCallParametersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ErrorResultDTO;
import org.eclipse.sensinact.northbound.rest.api.IRestNorthbound;
import org.eclipse.sensinact.northbound.session.ResourceShortDescription;
import org.eclipse.sensinact.northbound.session.SensiNactSession;

public class RestNorthbound
implements IRestNorthbound {
    @Context
    Sse sse;
    @Context
    Providers providers;
    @Context
    UriInfo uriInfo;

    private SensiNactSession getSession() {
        return (SensiNactSession)this.providers.getContextResolver(SensiNactSession.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private IQueryHandler getQueryHandler() {
        return (IQueryHandler)this.providers.getContextResolver(IQueryHandler.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private AbstractResultDTO handleQuery(AbstractQueryDTO query) {
        return this.getQueryHandler().handleQuery(this.getSession(), query);
    }

    private void injectFilter(QueryDescribeDTO query) {
        MultivaluedMap queryParameters = this.uriInfo.getQueryParameters(true);
        query.filter = (String)queryParameters.getFirst((Object)"filter");
        if (query.filter != null) {
            query.filterLanguage = queryParameters.containsKey((Object)"filterLanguage") ? (String)queryParameters.getFirst((Object)"filterLanguage") : "ldap";
        } else {
            query.filter = (String)queryParameters.getFirst((Object)"ldap");
            if (query.filter != null) {
                query.filterLanguage = "ldap";
            }
        }
    }

    private void injectFilter(QueryListDTO query) {
        MultivaluedMap queryParameters = this.uriInfo.getQueryParameters(true);
        query.filter = (String)queryParameters.getFirst((Object)"filter");
        query.filterLanguage = queryParameters.containsKey((Object)"filterLanguage") ? (String)queryParameters.getFirst((Object)"filterLanguage") : "ldap";
    }

    @Override
    public AbstractResultDTO describeProviders() {
        QueryDescribeDTO query = new QueryDescribeDTO();
        query.attrs = (List)this.uriInfo.getQueryParameters().getOrDefault((Object)"attrs", List.of());
        query.uri = new SensinactPath();
        this.injectFilter(query);
        return this.handleQuery((AbstractQueryDTO)query);
    }

    @Override
    public AbstractResultDTO listProviders() {
        QueryListDTO query = new QueryListDTO();
        query.uri = new SensinactPath();
        this.injectFilter(query);
        return this.handleQuery((AbstractQueryDTO)query);
    }

    @Override
    public AbstractResultDTO describeProvider(String providerId) {
        QueryDescribeDTO query = new QueryDescribeDTO();
        query.uri = new SensinactPath(providerId);
        this.injectFilter(query);
        return this.handleQuery((AbstractQueryDTO)query);
    }

    @Override
    public AbstractResultDTO listServices(String providerId) {
        QueryListDTO query = new QueryListDTO();
        query.uri = new SensinactPath(providerId);
        this.injectFilter(query);
        return this.handleQuery((AbstractQueryDTO)query);
    }

    @Override
    public AbstractResultDTO describeService(String providerId, String serviceName) {
        QueryDescribeDTO query = new QueryDescribeDTO();
        query.uri = new SensinactPath(providerId, serviceName);
        this.injectFilter(query);
        return this.handleQuery((AbstractQueryDTO)query);
    }

    @Override
    public AbstractResultDTO listResources(String providerId, String serviceName) {
        QueryListDTO query = new QueryListDTO();
        query.uri = new SensinactPath(providerId, serviceName);
        this.injectFilter(query);
        return this.handleQuery((AbstractQueryDTO)query);
    }

    @Override
    public AbstractResultDTO describeResource(String providerId, String serviceName, String rcName) {
        QueryDescribeDTO query = new QueryDescribeDTO();
        query.uri = new SensinactPath(providerId, serviceName, rcName);
        this.injectFilter(query);
        return this.handleQuery((AbstractQueryDTO)query);
    }

    @Override
    public AbstractResultDTO resourceGet(String providerId, String serviceName, String rcName, boolean includeMetadata) {
        QueryGetDTO query = new QueryGetDTO();
        query.uri = new SensinactPath(providerId, serviceName, rcName);
        query.includeMetadata = includeMetadata;
        return this.handleQuery((AbstractQueryDTO)query);
    }

    private Object extractSetValue(List<AccessMethodCallParameterDTO> parameters) {
        if (parameters == null || parameters.isEmpty() || parameters.size() > 2) {
            throw new IllegalArgumentException("Only 1 or 2 arguments are accepted");
        }
        Object newValue = null;
        if (parameters.size() == 2) {
            boolean gotValue = false;
            for (AccessMethodCallParameterDTO param : parameters) {
                if ("attributeName".equals(param.name)) {
                    if ("value".equals(param.value)) continue;
                    throw new IllegalArgumentException("Only the resource value can be set");
                }
                if ("value".equals(param.name)) {
                    newValue = param.value;
                    gotValue = true;
                    continue;
                }
                throw new IllegalArgumentException("Unsupported argument: " + param.name);
            }
            if (!gotValue) {
                throw new IllegalArgumentException("No value given");
            }
        } else {
            newValue = parameters.get((int)0).value;
        }
        return newValue;
    }

    @Override
    public AbstractResultDTO resourceSet(String providerId, String serviceName, String rcName, WrappedAccessMethodCallParametersDTO parameters) {
        QuerySetDTO query = new QuerySetDTO();
        query.uri = new SensinactPath(providerId, serviceName, rcName);
        query.value = this.extractSetValue(parameters.parameters);
        return this.handleQuery((AbstractQueryDTO)query);
    }

    private Map<String, Object> extractActParams(List<Map.Entry<String, Class<?>>> actMethodArgumentsTypes, List<AccessMethodCallParameterDTO> parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean named = false;
        boolean indexed = false;
        for (AccessMethodCallParameterDTO param : parameters) {
            String name;
            try {
                int givenIdx = Integer.parseInt(param.name);
                if (named) {
                    throw new IllegalArgumentException("Cannot mix positional and named arguments");
                }
                indexed = true;
                if (givenIdx < 0 || givenIdx >= actMethodArgumentsTypes.size()) {
                    throw new IllegalArgumentException("Given argument index is out of bounds: " + givenIdx);
                }
                name = actMethodArgumentsTypes.get(givenIdx).getKey();
            }
            catch (NumberFormatException e) {
                if (indexed) {
                    throw new IllegalArgumentException("Cannot mix positional and named arguments");
                }
                name = param.name;
            }
            if (params.containsKey(name)) {
                throw new IllegalArgumentException("Trying to overwrite given argument: " + name);
            }
            params.put(param.name, param.value);
        }
        return params;
    }

    @Override
    public AbstractResultDTO resourceAct(String providerId, String serviceName, String rcName, WrappedAccessMethodCallParametersDTO parameters) {
        ResourceShortDescription rcDesc = this.getSession().describeResourceShort(providerId, serviceName, rcName);
        if (rcDesc == null) {
            ErrorResultDTO error = new ErrorResultDTO();
            error.statusCode = 404;
            error.error = "Resource not found";
            error.uri = String.join((CharSequence)"/", providerId, serviceName, rcName);
            return error;
        }
        List actMethodArgumentsTypes = rcDesc.actMethodArgumentsTypes;
        QueryActDTO query = new QueryActDTO();
        query.uri = new SensinactPath(providerId, serviceName, rcName);
        query.parameters = this.extractActParams(actMethodArgumentsTypes, parameters.parameters);
        return this.handleQuery((AbstractQueryDTO)query);
    }

    @Override
    public void watchResource(String providerId, String serviceName, String rcName, SseEventSink eventSink) {
        SensiNactSession session = this.getSession();
        AtomicReference<String> listenerId = new AtomicReference<String>();
        Predicate<AbstractResourceNotification> filter = e -> providerId.equals(e.provider) && serviceName.equals(e.service) && rcName.equals(e.resource);
        ClientDataListener cdl = (t, e) -> {
            if (eventSink.isClosed()) {
                session.removeListener((String)listenerId.get());
                return;
            }
            if (filter.test((AbstractResourceNotification)e)) {
                eventSink.send(this.sse.newEventBuilder().name("data").mediaType(MediaType.APPLICATION_JSON_TYPE).data((Object)new ResourceDataNotificationDTO(e)).build());
            }
        };
        ClientLifecycleListener cll = (t, e) -> {
            if (eventSink.isClosed()) {
                session.removeListener((String)listenerId.get());
                return;
            }
            if (filter.test((AbstractResourceNotification)e)) {
                eventSink.send(this.sse.newEventBuilder().name("lifecycle").mediaType(MediaType.APPLICATION_JSON_TYPE).data((Object)new ResourceLifecycleNotificationDTO(e)).build());
            }
        };
        listenerId.set(session.addListener(List.of("*"), cdl, null, cll, null));
    }
}

