/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.whiteboard.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.annotation.verb.GetParam;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.core.twin.impl.TimedValueImpl;
import org.eclipse.sensinact.core.whiteboard.WhiteboardGet;
import org.eclipse.sensinact.core.whiteboard.impl.AbstractResourceMethod;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

class GetMethod
extends AbstractResourceMethod
implements WhiteboardGet<Object> {
    private final NullAction nullAction;

    public GetMethod(Method method, Object instance, Long serviceId, Set<String> providers, NullAction onNull) {
        super(method, instance, serviceId, providers);
        this.nullAction = onNull;
    }

    public NullAction actionOnNull() {
        return this.nullAction;
    }

    public Promise<TimedValue<Object>> pullValue(PromiseFactory pf, String modelPackageUri, String model, String provider, String service, String resource, Class<Object> resourceType, TimedValue<Object> cachedValue) {
        try {
            HashMap<Object, Object> params = new HashMap<Object, Object>();
            params.put(GetParam.GetSegment.RESULT_TYPE, resourceType);
            params.put(GetParam.GetSegment.CACHED_VALUE, cachedValue);
            Object result = super.invoke(modelPackageUri, model, provider, service, resource, params, GetParam.class, GetParam::value);
            if (result instanceof Promise) {
                return (Promise)result;
            }
            if (result instanceof TimedValue) {
                return pf.resolved((Object)((TimedValue)result));
            }
            if (result == null) {
                switch (this.nullAction) {
                    case IGNORE: {
                        return pf.resolved(null);
                    }
                    case UPDATE_IF_PRESENT: {
                        return pf.resolved(cachedValue == null || cachedValue.getTimestamp() == null ? null : new TimedValueImpl<Object>(null));
                    }
                    case UPDATE: {
                        return pf.resolved(new TimedValueImpl<Object>(null));
                    }
                }
                return pf.failed((Throwable)new IllegalArgumentException("Unknown null action: " + this.nullAction));
            }
            if (resourceType.isAssignableFrom(result.getClass())) {
                return pf.resolved(new TimedValueImpl<Object>(resourceType.cast(result)));
            }
            return pf.failed((Throwable)new Exception("Invalid result type: " + result.getClass()));
        }
        catch (Exception e) {
            return pf.failed((Throwable)e);
        }
    }
}

