/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbound.security.oidc;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.sensinact.gateway.northbound.security.oidc.Certificates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyResolver
implements SigningKeyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(SigningKeyResolver.class);
    private final List<Certificates.KeyInfo> keys;
    private final Map<String, Key> cachedKeys = new ConcurrentHashMap<String, Key>();
    private static final Map<String, String> EC_CURVE_NAME_MAPPING = Map.of("ES256", "secp256r1", "ES384", "secp384r1", "ES512", "secp521r1");

    public KeyResolver(List<Certificates.KeyInfo> keys) {
        this.keys = List.copyOf(keys);
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.fromCache(header);
    }

    private Key fromCache(JwsHeader<?> header) {
        return this.cachedKeys.computeIfAbsent(header.getKeyId(), k -> this.createKey((String)k, header.getAlgorithm()));
    }

    private Key createKey(String id, String algorithm) {
        return this.keys.stream().filter(k -> id.equalsIgnoreCase(k.getKeyId())).findFirst().map(k -> this.toKey(SignatureAlgorithm.forName((String)algorithm), (Certificates.KeyInfo)k)).orElse(null);
    }

    private Key toKey(SignatureAlgorithm alg, Certificates.KeyInfo ki) {
        try {
            switch (alg) {
                default: {
                    return null;
                }
                case ES256: 
                case ES384: 
                case ES512: {
                    return this.toECKey(ki);
                }
                case HS256: 
                case HS384: 
                case HS512: {
                    return this.toSecretKey(ki);
                }
                case PS256: 
                case PS384: 
                case PS512: 
                case RS256: 
                case RS384: 
                case RS512: 
            }
            return this.toRSAKey(ki);
        }
        catch (IllegalArgumentException | GeneralSecurityException gse) {
            LOG.error("Failed to create verification key for {}", (Object)ki.getKeyId(), (Object)gse);
            return null;
        }
    }

    private Key toECKey(Certificates.KeyInfo ki) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidParameterSpecException {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        BigInteger x = new BigInteger(1, decoder.decode(ki.getEcXCoordinate()));
        BigInteger y = new BigInteger(1, decoder.decode(ki.getEcYCoordinate()));
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
        parameters.init(new ECGenParameterSpec(EC_CURVE_NAME_MAPPING.get(ki.getEcCurve())));
        return KeyFactory.getInstance("EC").generatePublic(new ECPublicKeySpec(new ECPoint(x, y), parameters.getParameterSpec(ECParameterSpec.class)));
    }

    private Key toSecretKey(Certificates.KeyInfo ki) throws InvalidKeySpecException, NoSuchAlgorithmException {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        return new SecretKeySpec(decoder.decode(ki.getSymmetricKey()), SignatureAlgorithm.forName((String)ki.getAlgorithm()).getJcaName());
    }

    private Key toRSAKey(Certificates.KeyInfo ki) throws InvalidKeySpecException, NoSuchAlgorithmException {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        BigInteger modulus = new BigInteger(1, decoder.decode(ki.getRsaModulus()));
        BigInteger publicExponent = new BigInteger(1, decoder.decode(ki.getRsaExponent()));
        return KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
    }

    public Key resolveSigningKey(JwsHeader header, String plaintext) {
        return this.fromCache(header);
    }
}

