/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;

@Priority(value=4004)
public class CountFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String COUNT_PROP = "org.eclipse.sensinact.sensorthings.sensing.rest.count";

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Boolean addCount = (Boolean)requestContext.getProperty(COUNT_PROP);
        addCount = addCount == null ? Boolean.FALSE : addCount;
        Object entity = responseContext.getEntity();
        if (entity instanceof ResultList) {
            ResultList resultList = (ResultList)entity;
            if (!addCount.booleanValue()) {
                resultList.count = null;
            } else if (resultList.count == null) {
                resultList.count = resultList.value.size();
            }
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        boolean addCount = false;
        List list = (List)requestContext.getUriInfo().getQueryParameters().getOrDefault((Object)"$count", List.of());
        if (list.size() > 1) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Only one $count parameter may be provided").build());
        } else if (!list.isEmpty()) {
            String s = (String)list.get(0);
            if ("true".equals(s)) {
                addCount = true;
            } else if (!"false".equals(s)) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The $count parameter must be \"true\" or \"false\"").build());
            }
        }
        requestContext.setProperty(COUNT_PROP, (Object)addCount);
    }
}

