/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.HistoricalLocationsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.AbstractAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DatastreamsAccessImpl;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;

public class HistoricalLocationsAccessImpl
extends AbstractAccess
implements HistoricalLocationsAccess {
    public HistoricalLocation getHistoricalLocation(String id) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException("No feature of interest with id");
        }
        if (!hl.id.equals(id)) {
            throw new NotFoundException();
        }
        return hl;
    }

    public ResultList<Location> getHistoricalLocationLocations(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot));
        return list;
    }

    public Location getHistoricalLocationLocation(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        Location loc = DtoMapper.toLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
        if (!id2.equals(loc.id)) {
            throw new NotFoundException();
        }
        return loc;
    }

    public ResultList<Thing> getHistoricalLocationLocationThings(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toThing(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot));
        return list;
    }

    public ResultList<HistoricalLocation> getHistoricalLocationLocationHistoricalLocations(String id, String id2) {
        ResultList list = new ResultList();
        list.value = List.of(this.getHistoricalLocation(id));
        return list;
    }

    public Thing getHistoricalLocationThing(String id) {
        Thing t;
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        try {
            t = DtoMapper.toThing(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException("No feature of interest with id");
        }
        if (!t.id.equals(provider)) {
            throw new NotFoundException();
        }
        return t;
    }

    public ResultList<Datastream> getHistoricalLocationThingDatastreams(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        return DatastreamsAccessImpl.getDataStreams(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
    }

    public ResultList<HistoricalLocation> getHistoricalLocationThingHistoricalLocations(String id) {
        ResultList list = new ResultList();
        list.value = List.of(this.getHistoricalLocation(id));
        return list;
    }

    public ResultList<Location> getHistoricalLocationThingLocations(String id) {
        return this.getHistoricalLocationLocations(id);
    }
}

