/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.LocationPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.PathUtils;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.ThingPathHandler;

public class HistoricalLocationPathHandler {
    private final ProviderSnapshot provider;
    private final List<ResourceSnapshot> resources;
    private final Map<String, Function<String, Object>> subPartHandlers = Map.of("things", this::subThings, "locations", this::subLocations);

    public HistoricalLocationPathHandler(ProviderSnapshot provider, List<ResourceSnapshot> resources) {
        this.provider = provider;
        this.resources = resources;
    }

    public Object handle(String path) {
        String[] parts = path.toLowerCase().split("/");
        if (parts.length == 1) {
            switch (parts[0]) {
                case "id": {
                    return this.provider.getName();
                }
            }
            return PathUtils.getProviderLevelField(this.provider, this.resources, parts[0]);
        }
        Function<String, Object> handler = this.subPartHandlers.get(parts[0]);
        if (handler == null) {
            throw new UnsupportedRuleException("Unsupported path: " + path);
        }
        return handler.apply(String.join((CharSequence)"/", Arrays.copyOfRange(parts, 1, parts.length)));
    }

    private Object subThings(String path) {
        return new ThingPathHandler(this.provider, this.resources).handle(path);
    }

    private Object subLocations(String path) {
        return new LocationPathHandler(this.provider, this.resources).handle(path);
    }
}

