/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceValueFilter;
import org.eclipse.sensinact.northbound.filters.api.FilterParserException;
import org.eclipse.sensinact.northbound.filters.sensorthings.EFilterContext;
import org.eclipse.sensinact.northbound.filters.sensorthings.ISensorthingsFilterParser;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.ExpansionSettings;
import org.eclipse.sensinact.sensorthings.sensing.rest.RootResourceAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.AbstractAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;

public class RootResourceAccessImpl
extends AbstractAccess
implements RootResourceAccess {
    private ISensorthingsFilterParser getFilterParser() {
        return (ISensorthingsFilterParser)this.providers.getContextResolver(ISensorthingsFilterParser.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private ICriterion parseFilter(EFilterContext context) throws WebApplicationException {
        String filterString = (String)this.requestContext.getProperty("sensinact.sensorthings.filter");
        if (filterString == null || filterString.isBlank()) {
            return null;
        }
        try {
            return this.getFilterParser().parseFilter(filterString, context);
        }
        catch (FilterParserException e) {
            throw new BadRequestException("Error parsing filter", (Throwable)e);
        }
    }

    private List<ProviderSnapshot> listProviders(EFilterContext context) {
        SensiNactSession userSession = this.getSession();
        ICriterion criterion = this.parseFilter(context);
        List providers = userSession.filteredSnapshot(criterion);
        if (criterion != null && criterion.getResourceValueFilter() != null) {
            ResourceValueFilter rcFilter = criterion.getResourceValueFilter();
            return providers.stream().filter(p -> rcFilter.test(p, p.getServices().stream().flatMap(s -> s.getResources().stream()).collect(Collectors.toList()))).collect(Collectors.toList());
        }
        return providers;
    }

    private List<ResourceSnapshot> listSetResources(EFilterContext context) {
        return this.listResources(context).stream().filter(ResourceSnapshot::isSet).collect(Collectors.toList());
    }

    private List<ResourceSnapshot> listResources(EFilterContext context) {
        SensiNactSession userSession = this.getSession();
        ICriterion criterion = this.parseFilter(context);
        List providers = userSession.filteredSnapshot(criterion);
        if (criterion != null && criterion.getResourceValueFilter() != null) {
            ResourceValueFilter rcFilter = criterion.getResourceValueFilter();
            return providers.stream().flatMap(p -> p.getServices().stream()).flatMap(s -> s.getResources().stream()).filter(r -> rcFilter.test(r.getService().getProvider(), List.of(r))).collect(Collectors.toList());
        }
        return providers.stream().flatMap(p -> p.getServices().stream()).flatMap(s -> s.getResources().stream()).collect(Collectors.toList());
    }

    private static Optional<ResourceSnapshot> getResource(ProviderSnapshot provider, String svcName, String rcName) {
        return provider.getServices().stream().filter(s -> s.getName().equals(svcName)).flatMap(s -> s.getResources().stream()).filter(r -> r.getName().equals(rcName)).findFirst();
    }

    private boolean hasResourceSet(ProviderSnapshot provider, String svcName, String rcName) {
        if (provider == null) {
            return false;
        }
        Optional<ResourceSnapshot> resource = RootResourceAccessImpl.getResource(provider, svcName, rcName);
        if (resource.isEmpty()) {
            return false;
        }
        return resource.get().isSet();
    }

    public ResultList<Thing> getThings() {
        ResultList list = new ResultList();
        List<ProviderSnapshot> providers = this.listProviders(EFilterContext.THINGS);
        list.value = providers.stream().map(p -> DtoMapper.toThing(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), p)).collect(Collectors.toList());
        return list;
    }

    public ResultList<Location> getLocations() {
        ResultList list = new ResultList();
        List<ProviderSnapshot> providers = this.listProviders(EFilterContext.LOCATIONS);
        list.value = providers.stream().filter(p -> this.hasResourceSet((ProviderSnapshot)p, "admin", "location")).map(p -> DtoMapper.toLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), p)).collect(Collectors.toList());
        return list;
    }

    public ResultList<HistoricalLocation> getHistoricalLocations() {
        ResultList list = new ResultList();
        List<ProviderSnapshot> providers = this.listProviders(EFilterContext.HISTORICAL_LOCATIONS);
        list.value = providers.stream().filter(p -> this.hasResourceSet((ProviderSnapshot)p, "admin", "location")).map(p -> DtoMapper.toHistoricalLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), p)).collect(Collectors.toList());
        return list;
    }

    public ResultList<Datastream> getDatastreams() {
        ResultList list = new ResultList();
        List<ResourceSnapshot> resources = this.listSetResources(EFilterContext.DATASTREAMS);
        list.value = resources.stream().map(r -> DtoMapper.toDatastream(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), r)).collect(Collectors.toList());
        return list;
    }

    public ResultList<Sensor> getSensors() {
        ResultList list = new ResultList();
        List<ResourceSnapshot> resources = this.listSetResources(EFilterContext.SENSORS);
        list.value = resources.stream().map(r -> DtoMapper.toSensor(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), r)).collect(Collectors.toList());
        return list;
    }

    public ResultList<Observation> getObservations() {
        ResultList list = new ResultList();
        List<ResourceSnapshot> resources = this.listSetResources(EFilterContext.OBSERVATIONS);
        list.value = resources.stream().map(r -> DtoMapper.toObservation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), r)).collect(Collectors.toList());
        return list;
    }

    public ResultList<ObservedProperty> getObservedProperties() {
        ResultList list = new ResultList();
        List<ResourceSnapshot> resources = this.listSetResources(EFilterContext.OBSERVED_PROPERTIES);
        list.value = resources.stream().map(r -> DtoMapper.toObservedProperty(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), r)).collect(Collectors.toList());
        return list;
    }

    public ResultList<FeatureOfInterest> getFeaturesOfInterest() {
        ResultList list = new ResultList();
        List<ProviderSnapshot> providers = this.listProviders(EFilterContext.FEATURES_OF_INTEREST);
        list.value = providers.stream().map(p -> DtoMapper.toFeatureOfInterest(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), p)).collect(Collectors.toList());
        return list;
    }

    static ResultList<Observation> getObservationList(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ResourceSnapshot resourceSnapshot, int localResultLimit) {
        String provider = resourceSnapshot.getService().getProvider().getName();
        String service = resourceSnapshot.getService().getName();
        String resource = resourceSnapshot.getName();
        ResultList list = new ResultList();
        String historyProvider = (String)application.getProperties().get("sensinact.history.provider");
        Integer maxResults = (Integer)application.getProperties().get("sensinact.history.result.limit");
        if (localResultLimit > 0) {
            maxResults = Math.min(localResultLimit, maxResults);
        }
        ArrayList<Observation> results = new ArrayList<Observation>();
        if (historyProvider != null) {
            Long count = (Long)userSession.actOnResource(historyProvider, "history", "count", Map.of("provider", provider, "service", service, "resource", resource));
            list.count = count == null ? null : Integer.valueOf(count > Integer.MAX_VALUE ? Integer.MAX_VALUE : count.intValue());
            HashMap<String, String> params = new HashMap<String, String>(Map.of("provider", provider, "service", service, "resource", resource));
            Integer skip = 0;
            do {
                params.put("skip", (String)((Object)skip));
                List timed = (List)userSession.actOnResource(historyProvider, "history", "range", params);
                results.addAll(0, DtoMapper.toObservationList(userSession, application, mapper, uriInfo, expansions, resourceSnapshot, timed));
                if (timed.isEmpty()) break;
                if (timed.size() != 500) continue;
                skip = results.size();
            } while ((long)results.size() < count && results.size() < maxResults);
        }
        if (results.isEmpty() && resourceSnapshot.isSet()) {
            results.add(DtoMapper.toObservation(userSession, application, mapper, uriInfo, expansions, resourceSnapshot));
        }
        list.value = results;
        return list;
    }
}

