/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.SensorthingsMapper;
import org.osgi.util.promise.Promise;

public class SelectMapper
extends SensorthingsMapper<JsonNode> {
    private final SensorthingsMapper<?> mapper;
    private final Set<String> selected;

    public SelectMapper(String topicFilter, String selectFilter, SensorthingsMapper<?> mapper, ObjectMapper jsonMapper, GatewayThread thread) {
        super(topicFilter, jsonMapper, thread);
        this.mapper = mapper;
        this.selected = Arrays.stream(selectFilter.split(",")).collect(Collectors.toSet());
    }

    @Override
    public Promise<Stream<JsonNode>> toPayload(AbstractResourceNotification notification) {
        return this.mapper.toPayload(notification).map(s -> s.map(o -> ((ObjectNode)this.jsonMapper.convertValue(o, ObjectNode.class)).retain(this.selected)));
    }

    @Override
    protected Class<JsonNode> getPayloadType() {
        return JsonNode.class;
    }
}

