/*
 * Decompiled with CFR 0.152.
 */
package aQute.launcher.pre;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class EmbeddedLauncher {
    private static final File CWD = new File(System.getProperty("user.dir"));
    private static final String LAUNCH_TRACE = "launch.trace";
    private static final int BUFFER_SIZE = 65536;
    public static final String EMBEDDED_RUNPATH = "Embedded-Runpath";
    public static final String LAUNCHER_PATH = "launcher.runpath";
    public static Manifest MANIFEST;
    static int restarts;

    public static void main(String ... args) throws Throwable {
        boolean isVerbose = EmbeddedLauncher.isTrace();
        if (args.length > 0 && args[0].equals("-extract")) {
            if (isVerbose) {
                EmbeddedLauncher.log("running in extraction mode", new Object[0]);
            }
            EmbeddedLauncher.extract(args);
            return;
        }
        while (true) {
            try {
                System.setProperty("launch.framework.restart.count", Integer.toString(restarts));
                EmbeddedLauncher.findAndExecute(isVerbose, "main", Void.TYPE, args);
                return;
            }
            catch (Throwable e) {
                if (e.getClass().getSimpleName().equals("FrameworkRestart")) {
                    ++restarts;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public int run(String ... args) throws Throwable {
        boolean isVerbose = EmbeddedLauncher.isTrace();
        if (isVerbose) {
            EmbeddedLauncher.log("The following arguments are given:", new Object[0]);
            for (String arg : args) {
                EmbeddedLauncher.log(arg, new Object[0]);
            }
        }
        String methodName = "run";
        Class<Integer> returnType = Integer.TYPE;
        return EmbeddedLauncher.findAndExecute(isVerbose, methodName, returnType, args);
    }

    private static <T> T findAndExecute(boolean isVerbose, String methodName, Class<T> returnType, String ... args) throws Throwable {
        String runpath;
        ClassLoader cl = EmbeddedLauncher.class.getClassLoader();
        if (isVerbose) {
            EmbeddedLauncher.log("looking for Embedded-Runpath in META-INF/MANIFEST.MF", new Object[0]);
        }
        Enumeration<URL> manifests = cl.getResources("META-INF/MANIFEST.MF");
        while (manifests.hasMoreElements()) {
            Manifest m;
            String runpath2;
            URL murl = manifests.nextElement();
            if (isVerbose) {
                EmbeddedLauncher.log("found manifest %s", murl);
            }
            if ((runpath2 = (m = new Manifest(murl.openStream())).getMainAttributes().getValue(EMBEDDED_RUNPATH)) == null) continue;
            if (isVerbose) {
                EmbeddedLauncher.log("Going through the following Embedded-Runpath %s", runpath2);
            }
            MANIFEST = m;
            return EmbeddedLauncher.executeWithRunPath(isVerbose, methodName, returnType, cl, runpath2, false, args);
        }
        if (isVerbose) {
            EmbeddedLauncher.log("looking for -Dlauncher.runpath", new Object[0]);
        }
        if ((runpath = System.getProperty(LAUNCHER_PATH)) != null) {
            char q;
            int l;
            if (isVerbose) {
                EmbeddedLauncher.log("found -Dlauncher.runpath=%s", runpath);
            }
            if ((l = runpath.length() - 1) > 1 && ((q = runpath.charAt(0)) == '\'' || q == '\"') && q == runpath.charAt(l)) {
                runpath = runpath.substring(1, l);
            }
            return EmbeddedLauncher.executeWithRunPath(isVerbose, methodName, returnType, cl, runpath, true, args);
        }
        throw new RuntimeException("Found Nothing to launch. Maybe no Embedded-Runpath or -Dlauncher.runpath was set");
    }

    /*
     * Exception decompiling
     */
    private static <T> T executeWithRunPath(boolean isVerbose, String methodName, Class<T> returnType, ClassLoader cl, String runpath, boolean pathExternal, String ... args) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void log(String message, Object ... args) {
        System.out.println("[" + EmbeddedLauncher.class.getSimpleName() + "] " + String.format(message, args));
    }

    private static boolean isTrace() {
        return Boolean.getBoolean(LAUNCH_TRACE);
    }

    private static void extract(String ... args) throws URISyntaxException, IOException {
        File source;
        String to = "";
        if (args.length == 2) {
            to = args[1];
        }
        if (!(source = new File(EmbeddedLauncher.class.getProtectionDomain().getCodeSource().getLocation().toURI())).isFile()) {
            System.err.println("Cannot locate JAR file " + source);
            System.exit(-1);
        }
        File dir = to == null ? CWD : new File(to);
        dir.mkdirs();
        if (!dir.isDirectory()) {
            System.err.println("No such output directory : " + dir);
            System.exit(-1);
        }
        System.err.println("Extracting to " + dir);
        URI toFile = dir.toURI();
        try (JarFile jar = new JarFile(source);){
            jar.stream().forEach(entry -> {
                String method;
                String path = entry.getName();
                while (path.startsWith("/") || path.startsWith(".")) {
                    path = path.substring(1);
                }
                switch (entry.getMethod()) {
                    case 8: {
                        method = "<";
                        break;
                    }
                    case 0: {
                        method = "=";
                        break;
                    }
                    default: {
                        method = "?";
                    }
                }
                long size = entry.getSize();
                URI resolve = toFile.resolve(path);
                Path target = new File(resolve).toPath();
                System.out.printf("%s %5d %s%n", method, size, target);
                if (entry.isDirectory()) {
                    try {
                        if (!Files.isDirectory(target, new LinkOption[0])) {
                            Files.createDirectory(target, new FileAttribute[0]);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                } else {
                    try (InputStream inputStream = jar.getInputStream((ZipEntry)entry);){
                        Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
            });
        }
    }

    private static URL toFileURL(URL resource) throws IOException {
        if (resource.getProtocol().equalsIgnoreCase("file")) {
            return resource;
        }
        if (resource.getProtocol().equalsIgnoreCase("jrt")) {
            return resource;
        }
        File f = File.createTempFile("resource", ".jar");
        Files.createDirectories(f.getParentFile().toPath(), new FileAttribute[0]);
        try (InputStream in = resource.openStream();
             OutputStream out = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            int size;
            byte[] buffer = new byte[65536];
            while ((size = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, size);
            }
        }
        f.deleteOnExit();
        return f.toURI().toURL();
    }

    static {
        restarts = 0;
    }

    public static class Loader
    extends URLClassLoader {
        public Loader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

