/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.feature.utilities.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class InputStreamConsumer
implements Runnable {
    private InputStream inStream;
    private final Charset encoding;
    private ByteArrayOutputStream wholeBuffer;
    private ByteArrayOutputStream lastLineBuffer;
    private boolean newLine = false;

    public InputStreamConsumer(InputStream inStream) {
        this(inStream, true, false);
    }

    public InputStreamConsumer(InputStream inStream, boolean liveOutput, boolean keepData) {
        this(inStream, liveOutput, keepData, StandardCharsets.UTF_8);
    }

    public InputStreamConsumer(InputStream inStream, boolean liveOutput, boolean keepData, Charset encoding) {
        this.inStream = inStream;
        this.encoding = encoding;
        if (liveOutput) {
            this.lastLineBuffer = new ByteArrayOutputStream();
        }
        if (keepData) {
            this.wholeBuffer = new ByteArrayOutputStream();
        }
    }

    public void clear() {
        if (this.wholeBuffer != null) {
            this.wholeBuffer = new ByteArrayOutputStream();
        }
        if (this.lastLineBuffer != null) {
            this.lastLineBuffer = new ByteArrayOutputStream();
        }
    }

    public String getOutput() {
        if (this.wholeBuffer == null) {
            return null;
        }
        return this.wholeBuffer.toString(this.encoding);
    }

    @Override
    public void run() {
        try {
            int nextByte;
            while ((nextByte = this.inStream.read()) != -1) {
                if (this.wholeBuffer != null) {
                    this.wholeBuffer.write((byte)nextByte);
                }
                if (this.lastLineBuffer == null) continue;
                if (nextByte == 13 || nextByte == 10) {
                    if (this.newLine) {
                        System.out.println(this.lastLineBuffer.toString(this.encoding));
                        this.lastLineBuffer = new ByteArrayOutputStream();
                    }
                    this.newLine = false;
                    continue;
                }
                this.newLine = true;
                this.lastLineBuffer.write((byte)nextByte);
            }
        }
        catch (IOException e) {
            if (this.lastLineBuffer != null) {
                if (this.lastLineBuffer.size() > 0) {
                    System.out.println(this.lastLineBuffer.toString(this.encoding));
                }
                this.lastLineBuffer = null;
            }
            e.printStackTrace();
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

