/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.push;

import java.util.Objects;

public class DataUpdateException
extends Exception {
    private static final long serialVersionUID = -3948871450647637647L;
    private final String modelPackageUri;
    private final String model;
    private final String provider;
    private final String service;
    private final String resource;
    private final Object originalDto;

    public DataUpdateException(String modelPackageUri, String model, String provider, String service, String resource, Object originalDto, Throwable cause) {
        this(modelPackageUri, model, provider, service, resource, originalDto, cause == null ? DataUpdateException.getDefaultMessage(provider, service, resource) : cause.getMessage(), cause);
    }

    private static String getDefaultMessage(String provider, String service, String resource) {
        return String.format("Data update failed for %s/%s/%s", provider, service, resource);
    }

    protected DataUpdateException(String modelPackageUri, String model, String provider, String service, String resource, Object originalDto, String message, Throwable cause) {
        super(message, cause);
        Objects.requireNonNull(originalDto);
        this.modelPackageUri = modelPackageUri;
        this.model = model;
        this.provider = provider;
        this.service = service;
        this.resource = resource;
        this.originalDto = originalDto;
    }

    public String getModelPackageUri() {
        return this.modelPackageUri;
    }

    public String getModel() {
        return this.model;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getService() {
        return this.service;
    }

    public String getResource() {
        return this.resource;
    }

    public Object getOriginalDto() {
        return this.originalDto;
    }
}

