/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.dto;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.NameBinding;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplication;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationContentProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyExtensionProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyResourceProvider;
import org.eclipse.osgitech.rest.runtime.application.feature.WhiteboardFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.jakartars.runtime.dto.ApplicationDTO;
import org.osgi.service.jakartars.runtime.dto.BaseApplicationDTO;
import org.osgi.service.jakartars.runtime.dto.BaseDTO;
import org.osgi.service.jakartars.runtime.dto.BaseExtensionDTO;
import org.osgi.service.jakartars.runtime.dto.ExtensionDTO;
import org.osgi.service.jakartars.runtime.dto.FailedApplicationDTO;
import org.osgi.service.jakartars.runtime.dto.FailedExtensionDTO;
import org.osgi.service.jakartars.runtime.dto.FailedResourceDTO;
import org.osgi.service.jakartars.runtime.dto.ResourceDTO;
import org.osgi.service.jakartars.runtime.dto.ResourceMethodInfoDTO;
import org.osgi.service.jakartars.runtime.dto.RuntimeDTO;

public class DTOConverter {
    private static final List<String> POSSIBLE_EXTENSION_INTERFACES = Arrays.asList(ContainerRequestFilter.class.getName(), ContainerResponseFilter.class.getName(), ReaderInterceptor.class.getName(), WriterInterceptor.class.getName(), MessageBodyReader.class.getName(), MessageBodyWriter.class.getName(), ContextResolver.class.getName(), ExceptionMapper.class.getName(), ParamConverterProvider.class.getName(), Feature.class.getName(), DynamicFeature.class.getName());
    private static final String WHITEBOARD_FEATURE = WhiteboardFeature.class.getName();

    public static ApplicationDTO toApplicationDTO(JerseyApplicationProvider applicationProvider) {
        Long sid;
        if (applicationProvider == null) {
            throw new IllegalArgumentException("Expected an application provider to create an ApplicationDTO");
        }
        ApplicationDTO dto = new ApplicationDTO();
        dto.name = applicationProvider.getName();
        String basePath = applicationProvider.getPath();
        if (basePath != null) {
            dto.base = basePath.replaceAll("/\\*", "/");
        }
        dto.serviceId = (sid = applicationProvider.getServiceId()) != null ? sid : -1L;
        ArrayList<ResourceDTO> rdtos = new ArrayList<ResourceDTO>();
        ArrayList<ResourceMethodInfoDTO> rmidtos = new ArrayList<ResourceMethodInfoDTO>();
        ArrayList<ExtensionDTO> edtos = new ArrayList<ExtensionDTO>();
        ResourceConfig resourceConfig = applicationProvider.getJakartarsApplication();
        Application app = resourceConfig.getApplication();
        if (app instanceof ResourceConfig) {
            app = ((ResourceConfig)app).getApplication();
        }
        if (app instanceof JerseyApplication) {
            BaseDTO baseDTO;
            Application sourceApp = ((JerseyApplication)app).getSourceApplication();
            Set singletons = sourceApp.getSingletons();
            Set classes = sourceApp.getClasses();
            for (Object obj : singletons) {
                if (WHITEBOARD_FEATURE.equals(obj.getClass().getName())) continue;
                baseDTO = DTOConverter.toDTO(obj.getClass());
                if (baseDTO instanceof ResourceDTO) {
                    rdtos.add((ResourceDTO)baseDTO);
                    rmidtos.addAll(Arrays.asList(((ResourceDTO)baseDTO).resourceMethods));
                    continue;
                }
                edtos.add((ExtensionDTO)baseDTO);
            }
            for (Class c : classes) {
                if (WHITEBOARD_FEATURE.equals(c.getName())) continue;
                baseDTO = DTOConverter.toDTO(c);
                if (baseDTO instanceof ResourceDTO) {
                    rdtos.add((ResourceDTO)baseDTO);
                    rmidtos.addAll(Arrays.asList(((ResourceDTO)baseDTO).resourceMethods));
                    continue;
                }
                edtos.add((ExtensionDTO)baseDTO);
            }
        }
        if (applicationProvider.getContentProviders() != null) {
            for (JerseyApplicationContentProvider contentProvider : applicationProvider.getContentProviders()) {
                if (contentProvider instanceof JerseyResourceProvider) {
                    ResourceDTO resDTO = DTOConverter.toResourceDTO((JerseyResourceProvider)contentProvider);
                    rdtos.add(resDTO);
                    if (resDTO.resourceMethods == null) continue;
                    rmidtos.addAll(Arrays.asList(resDTO.resourceMethods));
                    continue;
                }
                if (!(contentProvider instanceof JerseyExtensionProvider)) continue;
                edtos.add(DTOConverter.toExtensionDTO((JerseyExtensionProvider)contentProvider));
            }
        }
        dto.resourceDTOs = rdtos.toArray(new ResourceDTO[rdtos.size()]);
        dto.extensionDTOs = edtos.toArray(new ExtensionDTO[edtos.size()]);
        dto.resourceMethods = rmidtos.toArray(new ResourceMethodInfoDTO[rmidtos.size()]);
        return dto;
    }

    public static FailedApplicationDTO toFailedApplicationDTO(JerseyApplicationProvider applicationProvider, int reason) {
        if (applicationProvider == null) {
            throw new IllegalArgumentException("Expected an application provider to create a FailedApplicationDTO");
        }
        FailedApplicationDTO dto = new FailedApplicationDTO();
        dto.name = applicationProvider.getName();
        dto.base = applicationProvider.getPath();
        Long sid = applicationProvider.getServiceId();
        dto.serviceId = sid != null ? sid : -1L;
        dto.failureReason = reason;
        return dto;
    }

    public static <T> ResourceDTO toResourceDTO(JerseyResourceProvider resourceProvider) {
        ResourceMethodInfoDTO[] rmiDTOs;
        if (resourceProvider == null) {
            throw new IllegalArgumentException("Expected an resource provider to create an ResourceDTO");
        }
        ResourceDTO dto = new ResourceDTO();
        dto.name = resourceProvider.getName();
        Long serviceId = resourceProvider.getServiceId();
        dto.serviceId = -1L;
        if (serviceId != null) {
            dto.serviceId = serviceId;
        }
        if ((rmiDTOs = DTOConverter.getResourceMethodInfoDTOs(resourceProvider.getObjectClass())) != null) {
            dto.resourceMethods = rmiDTOs;
        }
        return dto;
    }

    public static <T> BaseDTO toDTO(Class<?> clazz) {
        ResourceDTO dto = null;
        ResourceMethodInfoDTO[] rmiDTOs = DTOConverter.getResourceMethodInfoDTOs(clazz);
        if (rmiDTOs != null) {
            ResourceDTO resDTO = new ResourceDTO();
            resDTO.name = clazz.getName();
            resDTO.resourceMethods = rmiDTOs;
            dto = resDTO;
        } else {
            ExtensionDTO extDTO = new ExtensionDTO();
            extDTO.name = clazz.getName();
            LinkedList<String> extTypeList = new LinkedList<String>();
            for (Class<?> c : clazz.getInterfaces()) {
                if (!POSSIBLE_EXTENSION_INTERFACES.contains(c.getName())) continue;
                extTypeList.add(c.getName());
            }
            extDTO.extensionTypes = extTypeList.toArray(new String[0]);
            extDTO = DTOConverter.toExtensionDTO(clazz, extDTO);
            dto = extDTO;
        }
        return dto;
    }

    public static FailedResourceDTO toFailedResourceDTO(JerseyResourceProvider resourceProvider, int reason) {
        if (resourceProvider == null) {
            throw new IllegalArgumentException("Expected an resource provider to create an FailedResourceDTO");
        }
        FailedResourceDTO dto = new FailedResourceDTO();
        dto.name = resourceProvider.getName();
        Long serviceId = resourceProvider.getServiceId();
        dto.serviceId = serviceId != null ? serviceId : -1L;
        dto.failureReason = reason;
        return dto;
    }

    public static <T> ExtensionDTO toExtensionDTO(JerseyExtensionProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Expected an application content provider to create an ExtensionDTO");
        }
        ExtensionDTO dto = new ExtensionDTO();
        Class<?> clazz = provider.getObjectClass();
        dto = DTOConverter.toExtensionDTO(clazz, dto);
        Class[] contracts = provider.getContracts() == null ? new Class[]{} : provider.getContracts();
        String[] extTypes = new String[contracts.length];
        for (int c = 0; c < contracts.length; ++c) {
            extTypes[c] = contracts[c].getName();
        }
        dto.extensionTypes = extTypes;
        dto.name = provider.getName();
        Long serviceId = provider.getServiceId();
        dto.serviceId = -1L;
        if (serviceId != null) {
            dto.serviceId = serviceId;
        }
        return dto;
    }

    private static <T> ExtensionDTO toExtensionDTO(Class<?> clazz, ExtensionDTO dto) {
        Consumes consumes;
        Produces produces;
        LinkedList<String> nbList = new LinkedList<String>();
        for (Class<?> dc : clazz.getDeclaredClasses()) {
            NameBinding nb = dc.getAnnotation(NameBinding.class);
            if (nb == null || nbList.contains(dc.getName())) continue;
            nbList.add(dc.getName());
        }
        if (nbList.size() > 0) {
            dto.nameBindings = nbList.toArray(new String[0]);
        }
        if ((produces = clazz.getAnnotation(Produces.class)) != null) {
            dto.produces = produces.value();
        }
        if ((consumes = clazz.getAnnotation(Consumes.class)) != null) {
            dto.consumes = consumes.value();
        }
        return dto;
    }

    public static FailedExtensionDTO toFailedExtensionDTO(JerseyExtensionProvider provider, int reason) {
        if (provider == null) {
            throw new IllegalArgumentException("Expected an application content provider to create an FailedExtensionDTO");
        }
        FailedExtensionDTO dto = new FailedExtensionDTO();
        dto.name = provider.getName();
        Long serviceId = provider.getServiceId();
        dto.serviceId = serviceId != null ? serviceId : -1L;
        dto.failureReason = reason;
        return dto;
    }

    public static <T> ResourceMethodInfoDTO[] getResourceMethodInfoDTOs(Class<?> clazz) {
        return (ResourceMethodInfoDTO[])Stream.iterate(clazz, c -> c.getSuperclass()).takeWhile(c -> c != Object.class).flatMap(c -> Stream.concat(Arrays.stream(c.getInterfaces()), Stream.of(c))).flatMap(c -> DTOConverter.getResourceMethodInfoDTOsForType(c)).toArray(ResourceMethodInfoDTO[]::new);
    }

    private static <T> Stream<ResourceMethodInfoDTO> getResourceMethodInfoDTOsForType(Class<?> clazz) {
        Path resPath = clazz.getAnnotation(Path.class);
        Consumes resConsumes = clazz.getAnnotation(Consumes.class);
        Produces resProduces = clazz.getAnnotation(Produces.class);
        return Arrays.stream(clazz.isInterface() ? clazz.getMethods() : clazz.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && !m.isSynthetic()).map(m -> DTOConverter.toResourceMethodInfoDTO(m, resPath, resProduces, resConsumes)).filter(Objects::nonNull);
    }

    public static <T> ResourceMethodInfoDTO toResourceMethodInfoDTO(Method method, Path resPath, Produces resProduces, Consumes resConsumes) {
        Path path;
        Produces produces;
        if (method == null) {
            throw new IllegalArgumentException("Expected a method instance to introspect annpotations and create a ResourceMethodInfoDTO");
        }
        ResourceMethodInfoDTO dto = new ResourceMethodInfoDTO();
        String methodString = DTOConverter.getMethodStrings(method);
        if (methodString == null) {
            return null;
        }
        dto.method = methodString;
        String[] bindings = (String[])Arrays.stream(method.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(NameBinding.class)).map(a -> a.annotationType().getName()).distinct().toArray(String[]::new);
        dto.nameBindings = bindings.length == 0 ? null : bindings;
        Consumes consumes = Optional.ofNullable(method.getAnnotation(Consumes.class)).orElse(resConsumes);
        if (consumes != null) {
            dto.consumingMimeType = consumes.value();
        }
        if ((produces = Optional.ofNullable(method.getAnnotation(Produces.class)).orElse(resProduces)) != null) {
            dto.producingMimeType = produces.value();
        }
        dto.path = (path = method.getAnnotation(Path.class)) != null ? (resPath != null ? resPath.value() + "/" + path.value() : path.value()) : (resPath != null && methodString != null ? resPath.value() : "");
        return dto;
    }

    public static String getMethodStrings(Method method) {
        LinkedList<String> methods = new LinkedList<String>();
        DTOConverter.checkMethodString(method, GET.class, methods);
        DTOConverter.checkMethodString(method, POST.class, methods);
        DTOConverter.checkMethodString(method, PUT.class, methods);
        DTOConverter.checkMethodString(method, DELETE.class, methods);
        DTOConverter.checkMethodString(method, HEAD.class, methods);
        DTOConverter.checkMethodString(method, OPTIONS.class, methods);
        if (methods.isEmpty()) {
            return null;
        }
        return methods.stream().collect(Collectors.joining(","));
    }

    public static <T extends Annotation> void checkMethodString(Method method, Class<T> type, List<String> resultList) {
        T annotation = method.getAnnotation(type);
        if (annotation != null) {
            resultList.add(type.getSimpleName().toUpperCase());
        }
    }

    public static ServiceReferenceDTO toServiceReferenceDTO(ServiceReference<?> svc) {
        ServiceReferenceDTO dto = new ServiceReferenceDTO();
        dto.bundle = svc.getBundle().getBundleId();
        dto.id = (Long)svc.getProperty("service.id");
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String key : svc.getPropertyKeys()) {
            props.put(key, svc.getProperty(key));
        }
        dto.properties = new HashMap(props);
        Bundle[] ubs = svc.getUsingBundles();
        if (ubs == null) {
            dto.usingBundles = new long[0];
        } else {
            dto.usingBundles = new long[ubs.length];
            for (int j = 0; j < ubs.length; ++j) {
                dto.usingBundles[j] = ubs[j].getBundleId();
            }
        }
        return dto;
    }

    public static RuntimeDTO deepCopy(RuntimeDTO dto) {
        RuntimeDTO copy = new RuntimeDTO();
        copy.applicationDTOs = dto.applicationDTOs == null ? null : (ApplicationDTO[])Arrays.stream(dto.applicationDTOs).map(DTOConverter::deepCopy).toArray(ApplicationDTO[]::new);
        copy.defaultApplication = dto.defaultApplication == null ? null : DTOConverter.deepCopy(dto.defaultApplication);
        copy.failedApplicationDTOs = dto.failedApplicationDTOs == null ? null : (FailedApplicationDTO[])Arrays.stream(dto.failedApplicationDTOs).map(DTOConverter::deepCopy).toArray(FailedApplicationDTO[]::new);
        copy.failedExtensionDTOs = dto.failedExtensionDTOs == null ? null : (FailedExtensionDTO[])Arrays.stream(dto.failedExtensionDTOs).map(DTOConverter::deepCopy).toArray(FailedExtensionDTO[]::new);
        copy.failedResourceDTOs = dto.failedResourceDTOs == null ? null : (FailedResourceDTO[])Arrays.stream(dto.failedResourceDTOs).map(DTOConverter::deepCopy).toArray(FailedResourceDTO[]::new);
        copy.serviceDTO = dto.serviceDTO == null ? null : DTOConverter.deepCopy(dto.serviceDTO);
        return copy;
    }

    public static ApplicationDTO deepCopy(ApplicationDTO dto) {
        ApplicationDTO copy = new ApplicationDTO();
        DTOConverter.copyBaseApplication((BaseApplicationDTO)dto, (BaseApplicationDTO)copy);
        copy.resourceMethods = dto.resourceMethods == null ? null : (ResourceMethodInfoDTO[])Arrays.stream(dto.resourceMethods).map(DTOConverter::deepCopy).toArray(ResourceMethodInfoDTO[]::new);
        return copy;
    }

    private static void copyBaseApplication(BaseApplicationDTO dto, BaseApplicationDTO copy) {
        copy.base = dto.base;
        copy.extensionDTOs = dto.extensionDTOs == null ? null : (ExtensionDTO[])Arrays.stream(dto.extensionDTOs).map(DTOConverter::deepCopy).toArray(ExtensionDTO[]::new);
        copy.name = dto.name;
        copy.resourceDTOs = dto.resourceDTOs == null ? null : (ResourceDTO[])Arrays.stream(dto.resourceDTOs).map(DTOConverter::deepCopy).toArray(ResourceDTO[]::new);
        copy.serviceId = dto.serviceId;
    }

    public static FailedApplicationDTO deepCopy(FailedApplicationDTO dto) {
        FailedApplicationDTO copy = new FailedApplicationDTO();
        DTOConverter.copyBaseApplication((BaseApplicationDTO)dto, (BaseApplicationDTO)copy);
        copy.failureReason = dto.failureReason;
        return copy;
    }

    public static ExtensionDTO deepCopy(ExtensionDTO dto) {
        ExtensionDTO copy = new ExtensionDTO();
        DTOConverter.copyBaseExtension((BaseExtensionDTO)dto, (BaseExtensionDTO)copy);
        copy.consumes = dto.consumes == null ? null : (String[])dto.consumes.clone();
        copy.filteredByName = dto.filteredByName == null ? null : (ResourceDTO[])Arrays.stream(dto.filteredByName).map(DTOConverter::deepCopy).toArray(ResourceDTO[]::new);
        copy.nameBindings = dto.nameBindings == null ? null : (String[])dto.nameBindings.clone();
        copy.produces = dto.produces == null ? null : (String[])dto.produces.clone();
        return copy;
    }

    private static void copyBaseExtension(BaseExtensionDTO dto, BaseExtensionDTO copy) {
        copy.extensionTypes = dto.extensionTypes == null ? null : (String[])dto.extensionTypes.clone();
        copy.name = dto.name;
        copy.serviceId = dto.serviceId;
    }

    public static FailedExtensionDTO deepCopy(FailedExtensionDTO dto) {
        FailedExtensionDTO copy = new FailedExtensionDTO();
        DTOConverter.copyBaseExtension((BaseExtensionDTO)dto, (BaseExtensionDTO)copy);
        copy.failureReason = dto.failureReason;
        return copy;
    }

    public static ResourceDTO deepCopy(ResourceDTO dto) {
        ResourceDTO copy = new ResourceDTO();
        copy.name = dto.name;
        copy.resourceMethods = dto.resourceMethods == null ? null : (ResourceMethodInfoDTO[])Arrays.stream(dto.resourceMethods).map(DTOConverter::deepCopy).toArray(ResourceMethodInfoDTO[]::new);
        copy.serviceId = dto.serviceId;
        return copy;
    }

    public static FailedResourceDTO deepCopy(FailedResourceDTO dto) {
        FailedResourceDTO copy = new FailedResourceDTO();
        copy.name = dto.name;
        copy.serviceId = dto.serviceId;
        copy.failureReason = dto.failureReason;
        return copy;
    }

    public static ServiceReferenceDTO deepCopy(ServiceReferenceDTO dto) {
        ServiceReferenceDTO copy = new ServiceReferenceDTO();
        copy.bundle = dto.bundle;
        copy.id = dto.id;
        copy.properties = dto.properties == null ? null : new HashMap(dto.properties);
        copy.usingBundles = dto.usingBundles == null ? null : (long[])dto.usingBundles.clone();
        return copy;
    }

    public static ResourceMethodInfoDTO deepCopy(ResourceMethodInfoDTO dto) {
        ResourceMethodInfoDTO copy = new ResourceMethodInfoDTO();
        copy.consumingMimeType = dto.consumingMimeType == null ? null : (String[])dto.consumingMimeType.clone();
        copy.method = dto.method;
        copy.nameBindings = dto.nameBindings == null ? null : (String[])dto.nameBindings.clone();
        copy.path = dto.path;
        copy.producingMimeType = dto.producingMimeType == null ? null : (String[])dto.producingMimeType.clone();
        return copy;
    }
}

