/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public class ExtensionProxyFactory {
    private static final String OBJECT_INTERNAL_NAME = org.objectweb.asm.Type.getInternalName(Object.class);

    public static byte[] generateClass(String className, Object delegate, List<Class<?>> contracts) {
        Map<String, ParameterizedType> typeInfo = Arrays.stream(delegate.getClass().getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).collect(Collectors.toMap(i -> i.getRawType().getTypeName(), Function.identity()));
        String sig = ExtensionProxyFactory.generateGenericClassSignature(typeInfo, contracts);
        try {
            ClassWriter cw = new ClassWriter(2);
            String internalName = className.replace('.', '/');
            cw.visit(52, 1, internalName, sig, OBJECT_INTERNAL_NAME, (String[])contracts.stream().map(org.objectweb.asm.Type::getInternalName).toArray(String[]::new));
            for (Annotation annotation : delegate.getClass().getAnnotations()) {
                AnnotationVisitor av = cw.visitAnnotation(org.objectweb.asm.Type.getDescriptor(annotation.annotationType()), true);
                ExtensionProxyFactory.visitAnnotationMembers(annotation, av);
                av.visitEnd();
            }
            cw.visitField(18, "delegateSupplier", org.objectweb.asm.Type.getDescriptor(Supplier.class), null, null).visitEnd();
            MethodVisitor constructor = cw.visitMethod(1, "<init>", "(Ljava/util/function/Supplier;)V", null, null);
            constructor.visitCode();
            constructor.visitVarInsn(25, 0);
            constructor.visitMethodInsn(183, OBJECT_INTERNAL_NAME, "<init>", "()V", false);
            constructor.visitVarInsn(25, 0);
            constructor.visitVarInsn(25, 1);
            constructor.visitFieldInsn(181, internalName, "delegateSupplier", org.objectweb.asm.Type.getDescriptor(Supplier.class));
            constructor.visitInsn(177);
            constructor.visitMaxs(2, 2);
            constructor.visitEnd();
            for (Class<?> contract : contracts) {
                for (Method m : contract.getMethods()) {
                    MethodVisitor mv = cw.visitMethod(1, m.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)m), null, (String[])Arrays.stream(m.getExceptionTypes()).map(org.objectweb.asm.Type::getInternalName).toArray(String[]::new));
                    mv.visitCode();
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, internalName, "delegateSupplier", org.objectweb.asm.Type.getDescriptor(Supplier.class));
                    mv.visitMethodInsn(185, org.objectweb.asm.Type.getInternalName(Supplier.class), "get", org.objectweb.asm.Type.getMethodDescriptor((Method)Supplier.class.getMethod("get", new Class[0])), true);
                    mv.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(contract));
                    for (int i2 = 0; i2 < m.getParameterCount(); ++i2) {
                        mv.visitVarInsn(25, i2 + 1);
                    }
                    mv.visitMethodInsn(185, org.objectweb.asm.Type.getInternalName(contract), m.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)m), true);
                    if (m.getReturnType().equals(Void.TYPE)) {
                        mv.visitInsn(177);
                    } else if (m.getReturnType() == Boolean.TYPE || m.getReturnType() == Byte.TYPE || m.getReturnType() == Character.TYPE || m.getReturnType() == Integer.TYPE) {
                        mv.visitInsn(172);
                    } else if (m.getReturnType() == Long.TYPE) {
                        mv.visitInsn(173);
                    } else if (m.getReturnType() == Float.TYPE) {
                        mv.visitInsn(174);
                    } else if (m.getReturnType() == Double.TYPE) {
                        mv.visitInsn(175);
                    } else {
                        mv.visitInsn(176);
                    }
                    mv.visitMaxs(m.getParameterCount() + 1, m.getParameterCount() + 1);
                    mv.visitEnd();
                }
            }
            cw.visitEnd();
            return cw.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String generateGenericClassSignature(Map<String, ParameterizedType> typeInfo, List<Class<?>> contracts) {
        if (typeInfo.isEmpty()) {
            return null;
        }
        SignatureWriter sw = new SignatureWriter();
        SignatureVisitor sv = sw.visitSuperclass();
        sv.visitClassType(OBJECT_INTERNAL_NAME);
        sv.visitEnd();
        for (Class<?> contract : contracts) {
            if (!typeInfo.containsKey(contract.getName())) continue;
            SignatureVisitor iv = sw.visitInterface();
            iv.visitClassType(org.objectweb.asm.Type.getInternalName(contract));
            for (Type t : typeInfo.get(contract.getName()).getActualTypeArguments()) {
                ExtensionProxyFactory.visitTypeParameter(t, iv);
            }
            iv.visitEnd();
        }
        sw.visitEnd();
        return sw.toString();
    }

    private static void visitTypeParameter(Type t, SignatureVisitor sv) {
        SignatureVisitor pv = sv.visitTypeArgument('=');
        if (t instanceof Class) {
            Class clazz = (Class)t;
            if (clazz.isPrimitive()) {
                pv.visitBaseType(org.objectweb.asm.Type.getDescriptor((Class)clazz).charAt(0));
            } else if (clazz.isArray()) {
                SignatureVisitor av = pv.visitArrayType();
                ExtensionProxyFactory.visitTypeParameter(clazz.getComponentType(), av);
                av.visitEnd();
            } else {
                pv.visitClassType(org.objectweb.asm.Type.getInternalName((Class)clazz));
            }
        } else if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            pv.visitClassType(org.objectweb.asm.Type.getInternalName((Class)((Class)pt.getRawType())));
            Arrays.stream(pt.getActualTypeArguments()).forEach(ta -> ExtensionProxyFactory.visitTypeParameter(ta, pv));
        }
        pv.visitEnd();
    }

    private static void visitAnnotationMembers(Annotation a, AnnotationVisitor av) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : a.annotationType().getDeclaredMethods()) {
            AnnotationVisitor av2;
            Class<?> returnType = method.getReturnType();
            if (returnType.isAnnotation()) {
                av2 = av.visitAnnotation(method.getName(), org.objectweb.asm.Type.getDescriptor(returnType));
                ExtensionProxyFactory.visitAnnotationMembers((Annotation)method.invoke((Object)av2, new Object[0]), av2);
                av2.visitEnd();
                continue;
            }
            if (returnType.isEnum()) {
                Enum e = (Enum)method.invoke((Object)a, new Object[0]);
                av.visitEnum(method.getName(), org.objectweb.asm.Type.getInternalName(returnType), e.name());
                continue;
            }
            if (returnType.isArray() && !returnType.getComponentType().isPrimitive()) {
                av2 = av.visitArray(method.getName());
                Object[] values = (Object[])method.invoke((Object)a, new Object[0]);
                if (returnType.getComponentType().isAnnotation()) {
                    for (Object o : values) {
                        ExtensionProxyFactory.visitAnnotationMembers((Annotation)o, av2);
                    }
                } else if (returnType.getComponentType().isEnum()) {
                    String enumType = org.objectweb.asm.Type.getInternalName(returnType.getComponentType());
                    Object[] objectArray = values;
                    int n = objectArray.length;
                    for (int o = 0; o < n; ++o) {
                        Object o2 = objectArray[o];
                        av2.visitEnum(null, enumType, ((Enum)o2).name());
                    }
                } else {
                    for (Object o : values) {
                        av2.visit(null, o);
                    }
                }
                av2.visitEnd();
                continue;
            }
            av.visit(method.getName(), method.invoke((Object)a, new Object[0]));
        }
    }

    public static String getSimpleName(Integer rank, Long id) {
        String idHex;
        long serviceRank = (rank.longValue() - Integer.MAX_VALUE) * -1L;
        long serviceId = id;
        String rankHex = Long.toHexString(serviceRank);
        if (rankHex.length() < 8) {
            rankHex = "00000000".substring(rankHex.length(), 8).concat(rankHex);
        }
        if ((idHex = Long.toHexString(serviceId)).length() < 16) {
            idHex = "0000000000000000".substring(idHex.length(), 16).concat(idHex);
        }
        String simpleName = String.format("Extension_%s_%s", rankHex, idHex);
        return simpleName;
    }
}

