/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.httpwhiteboard;

import jakarta.servlet.Servlet;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.eclipse.osgitech.rest.annotations.ProvideRuntimeAdapter;
import org.eclipse.osgitech.rest.helper.JerseyHelper;
import org.eclipse.osgitech.rest.runtime.JerseyServiceRuntime;
import org.eclipse.osgitech.rest.runtime.WhiteboardServletContainer;
import org.glassfish.jersey.server.ResourceConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.servlet.context.ServletContextHelper;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.service.servlet.whiteboard.annotations.RequireHttpWhiteboard;

@ProvideRuntimeAdapter(value="osgi.http")
@RequireHttpWhiteboard
public class ServletWhiteboardBasedJerseyServiceRuntime {
    private final Logger logger = Logger.getLogger(ServletWhiteboardBasedJerseyServiceRuntime.class.getName());
    private final BundleContext context;
    private final String basePath;
    private final ServiceReference<HttpServiceRuntime> runtimeTarget;
    private final Long httpId;
    private final String httpWhiteboardTarget;
    private final JerseyServiceRuntime<WhiteboardServletContainer> runtime;
    private final Map<String, RestContext> pathsToServlets = new HashMap<String, RestContext>();
    private final AtomicInteger counter = new AtomicInteger();

    public ServletWhiteboardBasedJerseyServiceRuntime(BundleContext context, String basePath, ServiceReference<HttpServiceRuntime> runtimeTarget) {
        this.context = context;
        this.basePath = basePath;
        this.runtimeTarget = runtimeTarget;
        this.httpId = (Long)runtimeTarget.getProperty("service.id");
        this.httpWhiteboardTarget = String.format("(%s=%s)", "service.id", this.httpId);
        this.runtime = new JerseyServiceRuntime(context, this::registerContainer, this::unregisterContainer);
        this.runtime.start(Map.of("osgi.jakartars.endpoint", this.getURLs(), "service.description", "REST whiteboard for HttpServiceRuntime " + this.httpId));
    }

    private String[] getURLs() {
        String[] endpoints = JerseyHelper.getStringPlusProperty((String)"osgi.http.endpoint", (Map)FrameworkUtil.asMap((Dictionary)this.runtimeTarget.getProperties()));
        return (String[])Arrays.stream(endpoints).sorted(this::preferIPv4).map(s -> this.buildEndPoint((String)s, this.basePath)).toArray(String[]::new);
    }

    private int preferIPv4(String a, String b) {
        boolean bIPv6;
        if (a == null) {
            return b == null ? 0 : 1;
        }
        if (b == null) {
            return -1;
        }
        int aIdx = a.indexOf("://");
        int bIdx = b.indexOf("://");
        boolean aIPv6 = a.charAt(aIdx < 0 ? 0 : aIdx + 3) == '[';
        boolean bl = bIPv6 = b.charAt(bIdx < 0 ? 0 : bIdx + 3) == '[';
        if (aIPv6 && !bIPv6) {
            return 1;
        }
        if (!aIPv6 && bIPv6) {
            return -1;
        }
        return a.compareTo(b);
    }

    private String buildEndPoint(String endpoint, String path) {
        Object rsEndpoint = endpoint;
        if (!endpoint.endsWith("/")) {
            rsEndpoint = (String)rsEndpoint + "/";
        }
        if (!((String)(rsEndpoint = this.basePath.startsWith("/") ? (String)rsEndpoint + this.basePath.substring(1) : (String)rsEndpoint + this.basePath)).endsWith("/")) {
            rsEndpoint = (String)rsEndpoint + "/";
        }
        if (path != null && path.startsWith("/")) {
            rsEndpoint = (String)rsEndpoint + path.substring(1);
        }
        return rsEndpoint;
    }

    private WhiteboardServletContainer registerContainer(String path, ResourceConfig config) {
        ServiceRegistration helper;
        String contextId;
        String applicationPath = config.getApplicationPath() == null ? "" : config.getApplicationPath();
        Object contextPath = this.basePath.endsWith("/") ? this.basePath.substring(0, this.basePath.length() - 1) : this.basePath;
        if (((String)(contextPath = (String)contextPath + path.substring(0, path.length() - applicationPath.length()))).endsWith("/")) {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
        }
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        if ("/".equals(contextPath) && ".default".equals(config.getApplicationName())) {
            contextId = "default";
            helper = null;
        } else {
            contextId = String.format("ContextForRestWhiteboard.%s.instance.%s", this.httpId, this.counter.incrementAndGet());
            Hashtable<String, Object> contextHelperProps = new Hashtable<String, Object>();
            ((Dictionary)contextHelperProps).put("osgi.http.whiteboard.target", this.httpWhiteboardTarget);
            ((Dictionary)contextHelperProps).put("osgi.http.whiteboard.context.name", contextId);
            ((Dictionary)contextHelperProps).put("osgi.http.whiteboard.context.path", contextPath);
            helper = this.context.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, contextHelperProps);
        }
        Hashtable<String, Object> servletProps = new Hashtable<String, Object>();
        Object servletPath = applicationPath;
        if (!((String)servletPath).startsWith("/")) {
            servletPath = "/" + (String)servletPath;
        }
        servletPath = ((String)servletPath).endsWith("/") ? (String)servletPath + "*" : (String)servletPath + "/*";
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", servletPath);
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.asyncSupported", Boolean.TRUE);
        ((Dictionary)servletProps).put("osgi.http.whiteboard.target", this.httpWhiteboardTarget);
        ((Dictionary)servletProps).put("osgi.http.whiteboard.context.select", String.format("(osgi.http.whiteboard.context.name=%s)", contextId));
        WhiteboardServletContainer container = new WhiteboardServletContainer(config);
        RestContext rest = new RestContext((ServiceRegistration<ServletContextHelper>)helper, (ServiceRegistration<Servlet>)this.context.registerService(Servlet.class, (Object)container, servletProps), container);
        this.pathsToServlets.put(path, rest);
        return container;
    }

    private void unregisterContainer(String path, WhiteboardServletContainer container) {
        RestContext rest = this.pathsToServlets.remove(path);
        if (rest != null) {
            rest.servletReg.unregister();
            if (rest.contextHelperReg != null) {
                rest.contextHelperReg.unregister();
            }
            rest.servlet.dispose();
        }
        container.dispose();
    }

    public void teardown(long i, TimeUnit seconds) {
        this.runtime.teardown(i, seconds);
    }

    private static class RestContext {
        private final ServiceRegistration<ServletContextHelper> contextHelperReg;
        private final ServiceRegistration<Servlet> servletReg;
        private final WhiteboardServletContainer servlet;

        public RestContext(ServiceRegistration<ServletContextHelper> contextHelperReg, ServiceRegistration<Servlet> servletReg, WhiteboardServletContainer servlet) {
            this.contextHelperReg = contextHelperReg;
            this.servletReg = servletReg;
            this.servlet = servlet;
        }
    }
}

